@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3BucketName The name of the Amazon S3 bucket containing the package.
 * @property s3Key Key (file name) of the package.
 */
public data class PackagePackageSourceArgs(
    public val s3BucketName: Output<String>,
    public val s3Key: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs =
        com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs.builder()
            .s3BucketName(s3BucketName.applyValue({ args0 -> args0 }))
            .s3Key(s3Key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackagePackageSourceArgs].
 */
@PulumiTagMarker
public class PackagePackageSourceArgsBuilder internal constructor() {
    private var s3BucketName: Output<String>? = null

    private var s3Key: Output<String>? = null

    /**
     * @param value The name of the Amazon S3 bucket containing the package.
     */
    @JvmName("wwwnmbsotgbvdwio")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value Key (file name) of the package.
     */
    @JvmName("nthaydjbuxsmwruo")
    public suspend fun s3Key(`value`: Output<String>) {
        this.s3Key = value
    }

    /**
     * @param value The name of the Amazon S3 bucket containing the package.
     */
    @JvmName("yalivcnyyekkewlg")
    public suspend fun s3BucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value Key (file name) of the package.
     */
    @JvmName("ifswoxisbmiuwbij")
    public suspend fun s3Key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Key = mapped
    }

    internal fun build(): PackagePackageSourceArgs = PackagePackageSourceArgs(
        s3BucketName = s3BucketName ?: throw PulumiNullFieldException("s3BucketName"),
        s3Key = s3Key ?: throw PulumiNullFieldException("s3Key"),
    )
}
