@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.inputs

import com.pulumi.aws.opensearch.inputs.ServerlessCollectionTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create
 * @property delete
 */
public data class ServerlessCollectionTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.inputs.ServerlessCollectionTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.inputs.ServerlessCollectionTimeoutsArgs =
        com.pulumi.aws.opensearch.inputs.ServerlessCollectionTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessCollectionTimeoutsArgs].
 */
@PulumiTagMarker
public class ServerlessCollectionTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("bglkrcixiiosaqnm")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value
     */
    @JvmName("jjsrnhmmoltnrynm")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value
     */
    @JvmName("fsejtpfcooyuvooo")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value
     */
    @JvmName("chucdbnbfpshybpo")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    internal fun build(): ServerlessCollectionTimeoutsArgs = ServerlessCollectionTimeoutsArgs(
        create = create,
        delete = delete,
    )
}
