@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property masterUserArn ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
 * @property masterUserName Main user's username, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
 * @property masterUserPassword Main user's password, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
 */
public data class DomainAdvancedSecurityOptionsMasterUserOptions(
    public val masterUserArn: String? = null,
    public val masterUserName: String? = null,
    public val masterUserPassword: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainAdvancedSecurityOptionsMasterUserOptions):
            DomainAdvancedSecurityOptionsMasterUserOptions =
            DomainAdvancedSecurityOptionsMasterUserOptions(
                masterUserArn = javaType.masterUserArn().map({ args0 -> args0 }).orElse(null),
                masterUserName = javaType.masterUserName().map({ args0 -> args0 }).orElse(null),
                masterUserPassword = javaType.masterUserPassword().map({ args0 -> args0 }).orElse(null),
            )
    }
}
