@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property desiredState Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
 * @property maintenanceSchedules Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
 * @property rollbackOnDisable Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
 */
public data class DomainAutoTuneOptions(
    public val desiredState: String,
    public val maintenanceSchedules: List<DomainAutoTuneOptionsMaintenanceSchedule>? = null,
    public val rollbackOnDisable: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainAutoTuneOptions):
            DomainAutoTuneOptions = DomainAutoTuneOptions(
            desiredState = javaType.desiredState(),
            maintenanceSchedules = javaType.maintenanceSchedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.DomainAutoTuneOptionsMaintenanceSchedule.Companion.toKotlin(args0)
                })
            }),
            rollbackOnDisable = javaType.rollbackOnDisable().map({ args0 -> args0 }).orElse(null),
        )
    }
}
