@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customEndpoint Fully qualified domain for your custom endpoint.
 * @property customEndpointCertificateArn ACM certificate ARN for your custom endpoint.
 * @property customEndpointEnabled Whether to enable custom endpoint for the OpenSearch domain.
 * @property enforceHttps Whether or not to require HTTPS. Defaults to `true`.
 * @property tlsSecurityPolicy Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07` and `Policy-Min-TLS-1-2-2019-07`. The provider will only perform drift detection if a configuration value is provided.
 */
public data class DomainDomainEndpointOptions(
    public val customEndpoint: String? = null,
    public val customEndpointCertificateArn: String? = null,
    public val customEndpointEnabled: Boolean? = null,
    public val enforceHttps: Boolean? = null,
    public val tlsSecurityPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainDomainEndpointOptions):
            DomainDomainEndpointOptions = DomainDomainEndpointOptions(
            customEndpoint = javaType.customEndpoint().map({ args0 -> args0 }).orElse(null),
            customEndpointCertificateArn = javaType.customEndpointCertificateArn().map({ args0 ->
                args0
            }).orElse(null),
            customEndpointEnabled = javaType.customEndpointEnabled().map({ args0 -> args0 }).orElse(null),
            enforceHttps = javaType.enforceHttps().map({ args0 -> args0 }).orElse(null),
            tlsSecurityPolicy = javaType.tlsSecurityPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
