@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ebsEnabled Whether EBS volumes are attached to data nodes in the domain.
 * @property iops Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
 * @property throughput Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
 * @property volumeSize Size of EBS volumes attached to data nodes (in GiB).
 * @property volumeType Type of EBS volumes attached to data nodes.
 */
public data class DomainEbsOptions(
    public val ebsEnabled: Boolean,
    public val iops: Int? = null,
    public val throughput: Int? = null,
    public val volumeSize: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainEbsOptions):
            DomainEbsOptions = DomainEbsOptions(
            ebsEnabled = javaType.ebsEnabled(),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
            volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
