@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogGroupArn ARN of the Cloudwatch log group to which log needs to be published.
 * @property enabled Whether given log publishing option is enabled or not.
 * @property logType Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
 */
public data class DomainLogPublishingOption(
    public val cloudwatchLogGroupArn: String,
    public val enabled: Boolean? = null,
    public val logType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.DomainLogPublishingOption):
            DomainLogPublishingOption = DomainLogPublishingOption(
            cloudwatchLogGroupArn = javaType.cloudwatchLogGroupArn(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            logType = javaType.logType(),
        )
    }
}
