@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property desiredState Auto-Tune desired state for the domain.
 * @property maintenanceSchedules A list of the nested configurations for the Auto-Tune maintenance windows of the domain.
 * @property rollbackOnDisable Whether the domain is set to roll back to default Auto-Tune settings when disabling Auto-Tune.
 */
public data class GetDomainAutoTuneOption(
    public val desiredState: String,
    public val maintenanceSchedules: List<GetDomainAutoTuneOptionMaintenanceSchedule>,
    public val rollbackOnDisable: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainAutoTuneOption):
            GetDomainAutoTuneOption = GetDomainAutoTuneOption(
            desiredState = javaType.desiredState(),
            maintenanceSchedules = javaType.maintenanceSchedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainAutoTuneOptionMaintenanceSchedule.Companion.toKotlin(args0)
                })
            }),
            rollbackOnDisable = javaType.rollbackOnDisable(),
        )
    }
}
