@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property coldStorageOptions Configuration block containing cold storage configuration.
 * @property dedicatedMasterCount Number of dedicated master nodes in the cluster.
 * @property dedicatedMasterEnabled Indicates whether dedicated master nodes are enabled for the cluster.
 * @property dedicatedMasterType Instance type of the dedicated master nodes in the cluster.
 * @property instanceCount Number of instances in the cluster.
 * @property instanceType Instance type of data nodes in the cluster.
 * @property multiAzWithStandbyEnabled
 * @property warmCount Number of warm nodes in the cluster.
 * @property warmEnabled Warm storage is enabled.
 * @property warmType Instance type for the OpenSearch cluster's warm nodes.
 * @property zoneAwarenessConfigs Configuration block containing zone awareness settings.
 * @property zoneAwarenessEnabled Indicates whether zone awareness is enabled.
 */
public data class GetDomainClusterConfig(
    public val coldStorageOptions: List<GetDomainClusterConfigColdStorageOption>,
    public val dedicatedMasterCount: Int,
    public val dedicatedMasterEnabled: Boolean,
    public val dedicatedMasterType: String,
    public val instanceCount: Int,
    public val instanceType: String,
    public val multiAzWithStandbyEnabled: Boolean,
    public val warmCount: Int,
    public val warmEnabled: Boolean? = null,
    public val warmType: String,
    public val zoneAwarenessConfigs: List<GetDomainClusterConfigZoneAwarenessConfig>,
    public val zoneAwarenessEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainClusterConfig):
            GetDomainClusterConfig = GetDomainClusterConfig(
            coldStorageOptions = javaType.coldStorageOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainClusterConfigColdStorageOption.Companion.toKotlin(args0)
                })
            }),
            dedicatedMasterCount = javaType.dedicatedMasterCount(),
            dedicatedMasterEnabled = javaType.dedicatedMasterEnabled(),
            dedicatedMasterType = javaType.dedicatedMasterType(),
            instanceCount = javaType.instanceCount(),
            instanceType = javaType.instanceType(),
            multiAzWithStandbyEnabled = javaType.multiAzWithStandbyEnabled(),
            warmCount = javaType.warmCount(),
            warmEnabled = javaType.warmEnabled().map({ args0 -> args0 }).orElse(null),
            warmType = javaType.warmType(),
            zoneAwarenessConfigs = javaType.zoneAwarenessConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetDomainClusterConfigZoneAwarenessConfig.Companion.toKotlin(args0)
                })
            }),
            zoneAwarenessEnabled = javaType.zoneAwarenessEnabled(),
        )
    }
}
