@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Enabled disabled toggle for off-peak update window
 * @property identityPoolId Cognito Identity pool used by the domain.
 * @property roleArn IAM Role with the AmazonOpenSearchServiceCognitoAccess policy attached.
 * @property userPoolId Cognito User pool used by the domain.
 */
public data class GetDomainCognitoOption(
    public val enabled: Boolean,
    public val identityPoolId: String,
    public val roleArn: String,
    public val userPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainCognitoOption):
            GetDomainCognitoOption = GetDomainCognitoOption(
            enabled = javaType.enabled(),
            identityPoolId = javaType.identityPoolId(),
            roleArn = javaType.roleArn(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
