@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Enabled disabled toggle for off-peak update window
 * @property kmsKeyId KMS key id used to encrypt data at rest.
 */
public data class GetDomainEncryptionAtRest(
    public val enabled: Boolean,
    public val kmsKeyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetDomainEncryptionAtRest):
            GetDomainEncryptionAtRest = GetDomainEncryptionAtRest(
            enabled = javaType.enabled(),
            kmsKeyId = javaType.kmsKeyId(),
        )
    }
}
