@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getServerlessCollection.
 * @property arn Amazon Resource Name (ARN) of the collection.
 * @property collectionEndpoint Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch Serverless collection.
 * @property createdDate Date the Collection was created.
 * @property dashboardEndpoint Collection-specific endpoint used to access OpenSearch Dashboards.
 * @property description Description of the collection.
 * @property id
 * @property kmsKeyArn The ARN of the Amazon Web Services KMS key used to encrypt the collection.
 * @property lastModifiedDate Date the Collection was last modified.
 * @property name
 * @property tags A map of tags to assign to the collection.
 * @property type Type of collection.
 */
public data class GetServerlessCollectionResult(
    public val arn: String,
    public val collectionEndpoint: String,
    public val createdDate: String,
    public val dashboardEndpoint: String,
    public val description: String,
    public val id: String,
    public val kmsKeyArn: String,
    public val lastModifiedDate: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetServerlessCollectionResult):
            GetServerlessCollectionResult = GetServerlessCollectionResult(
            arn = javaType.arn(),
            collectionEndpoint = javaType.collectionEndpoint(),
            createdDate = javaType.createdDate(),
            dashboardEndpoint = javaType.dashboardEndpoint(),
            description = javaType.description(),
            id = javaType.id(),
            kmsKeyArn = javaType.kmsKeyArn(),
            lastModifiedDate = javaType.lastModifiedDate(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
