@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getServerlessSecurityConfig.
 * @property configVersion The version of the security configuration.
 * @property createdDate The date the configuration was created.
 * @property description The description of the security configuration.
 * @property id
 * @property lastModifiedDate The date the configuration was last modified.
 * @property samlOptions SAML options for the security configuration.
 * @property type The type of security configuration.
 */
public data class GetServerlessSecurityConfigResult(
    public val configVersion: String,
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val lastModifiedDate: String,
    public val samlOptions: GetServerlessSecurityConfigSamlOptions? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetServerlessSecurityConfigResult):
            GetServerlessSecurityConfigResult = GetServerlessSecurityConfigResult(
            configVersion = javaType.configVersion(),
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            id = javaType.id(),
            lastModifiedDate = javaType.lastModifiedDate(),
            samlOptions = javaType.samlOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessSecurityConfigSamlOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
