@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getServerlessSecurityPolicy.
 * @property createdDate The date the security policy was created.
 * @property description Description of the security policy.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastModifiedDate The date the security policy was last modified.
 * @property name
 * @property policy The JSON policy document without any whitespaces.
 * @property policyVersion Version of the policy.
 * @property type
 */
public data class GetServerlessSecurityPolicyResult(
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val lastModifiedDate: String,
    public val name: String,
    public val policy: String,
    public val policyVersion: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetServerlessSecurityPolicyResult):
            GetServerlessSecurityPolicyResult = GetServerlessSecurityPolicyResult(
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            id = javaType.id(),
            lastModifiedDate = javaType.lastModifiedDate(),
            name = javaType.name(),
            policy = javaType.policy(),
            policyVersion = javaType.policyVersion(),
            type = javaType.type(),
        )
    }
}
