@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerlessVpcEndpoint.
 * @property createdDate The date the endpoint was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name The name of the endpoint.
 * @property securityGroupIds The IDs of the security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
 * @property subnetIds The IDs of the subnets from which you access OpenSearch Serverless.
 * @property vpcEndpointId
 * @property vpcId The ID of the VPC from which you access OpenSearch Serverless.
 */
public data class GetServerlessVpcEndpointResult(
    public val createdDate: String,
    public val id: String,
    public val name: String,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcEndpointId: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.GetServerlessVpcEndpointResult):
            GetServerlessVpcEndpointResult = GetServerlessVpcEndpointResult(
            createdDate = javaType.createdDate(),
            id = javaType.id(),
            name = javaType.name(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcEndpointId = javaType.vpcEndpointId(),
            vpcId = javaType.vpcId(),
        )
    }
}
