@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property crossClusterSearch Configuration block for cross cluster search.
 * @property endpoint The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
 */
public data class OutboundConnectionConnectionProperties(
    public val crossClusterSearch: OutboundConnectionConnectionPropertiesCrossClusterSearch? = null,
    public val endpoint: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.OutboundConnectionConnectionProperties):
            OutboundConnectionConnectionProperties = OutboundConnectionConnectionProperties(
            crossClusterSearch = javaType.crossClusterSearch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionConnectionPropertiesCrossClusterSearch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
