@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName The name of the local domain.
 * @property ownerId The Account ID of the owner of the local domain.
 * @property region The region of the local domain.
 */
public data class OutboundConnectionLocalDomainInfo(
    public val domainName: String,
    public val ownerId: String,
    public val region: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.opensearch.outputs.OutboundConnectionLocalDomainInfo):
            OutboundConnectionLocalDomainInfo = OutboundConnectionLocalDomainInfo(
            domainName = javaType.domainName(),
            ownerId = javaType.ownerId(),
            region = javaType.region(),
        )
    }
}
