@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.kotlin.outputs.ApplicationAppSource
import com.pulumi.aws.opsworks.kotlin.outputs.ApplicationEnvironment
import com.pulumi.aws.opsworks.kotlin.outputs.ApplicationSslConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.opsworks.kotlin.outputs.ApplicationAppSource.Companion.toKotlin as applicationAppSourceToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.ApplicationEnvironment.Companion.toKotlin as applicationEnvironmentToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.ApplicationSslConfiguration.Companion.toKotlin as applicationSslConfigurationToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.aws.opsworks.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks application resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Application;
 * import com.pulumi.aws.opsworks.ApplicationArgs;
 * import com.pulumi.aws.opsworks.inputs.ApplicationEnvironmentArgs;
 * import com.pulumi.aws.opsworks.inputs.ApplicationAppSourceArgs;
 * import com.pulumi.aws.opsworks.inputs.ApplicationSslConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo_app = new Application("foo-app", ApplicationArgs.builder()
 *             .shortName("foobar")
 *             .stackId(aws_opsworks_stack.main().id())
 *             .type("rails")
 *             .description("This is a Rails application")
 *             .domains(
 *                 "example.com",
 *                 "sub.example.com")
 *             .environments(ApplicationEnvironmentArgs.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .secure(false)
 *                 .build())
 *             .appSources(ApplicationAppSourceArgs.builder()
 *                 .type("git")
 *                 .revision("master")
 *                 .url("https://github.com/example.git")
 *                 .build())
 *             .enableSsl(true)
 *             .sslConfigurations(ApplicationSslConfigurationArgs.builder()
 *                 .privateKey(Files.readString(Paths.get("./foobar.key")))
 *                 .certificate(Files.readString(Paths.get("./foobar.crt")))
 *                 .build())
 *             .documentRoot("public")
 *             .autoBundleOnDeploy(true)
 *             .railsEnv("staging")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Opsworks Application using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:opsworks/application:Application test <id>
 * ```
 *
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * SCM configuration of the app as described below.
     */
    public val appSources: Output<List<ApplicationAppSource>>
        get() = javaResource.appSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationAppSourceToKotlin(args0)
                })
            })
        })

    /**
     * Run bundle install when deploying for application of type `rails`.
     */
    public val autoBundleOnDeploy: Output<String>?
        get() = javaResource.autoBundleOnDeploy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify activity and workflow workers for your app using the aws-flow gem.
     */
    public val awsFlowRubySettings: Output<String>?
        get() = javaResource.awsFlowRubySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The data source's ARN.
     */
    public val dataSourceArn: Output<String>?
        get() = javaResource.dataSourceArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The database name.
     */
    public val dataSourceDatabaseName: Output<String>?
        get() = javaResource.dataSourceDatabaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The data source's type one of `AutoSelectOpsworksMysqlInstance`, `OpsworksMysqlInstance`, or `RdsDbInstance`.
     */
    public val dataSourceType: Output<String>?
        get() = javaResource.dataSourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A description of the app.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subfolder for the document root for application of type `rails`.
     */
    public val documentRoot: Output<String>?
        get() = javaResource.documentRoot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of virtual host alias.
     */
    public val domains: Output<List<String>>?
        get() = javaResource.domains().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Whether to enable SSL for the app. This must be set in order to let `ssl_configuration.private_key`, `ssl_configuration.certificate` and `ssl_configuration.chain` take effect.
     */
    public val enableSsl: Output<Boolean>?
        get() = javaResource.enableSsl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Object to define environment variables.  Object is described below.
     */
    public val environments: Output<List<ApplicationEnvironment>>?
        get() = javaResource.environments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> applicationEnvironmentToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A human-readable name for the application.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the Rails environment for application of type `rails`.
     */
    public val railsEnv: Output<String>?
        get() = javaResource.railsEnv().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A short, machine-readable name for the application. This can only be defined on resource creation and ignored on resource update.
     */
    public val shortName: Output<String>
        get() = javaResource.shortName().applyValue({ args0 -> args0 })

    /**
     * The SSL configuration of the app. Object is described below.
     */
    public val sslConfigurations: Output<List<ApplicationSslConfiguration>>?
        get() = javaResource.sslConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationSslConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * ID of the stack the application will belong to.
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * Opsworks application type. One of `aws-flow-ruby`, `java`, `rails`, `php`, `nodejs`, `static` or `other`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.aws.opsworks.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit):
    Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
