@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.CustomLayerArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.CustomLayerCloudwatchConfigurationArgs
import com.pulumi.aws.opsworks.kotlin.inputs.CustomLayerCloudwatchConfigurationArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.CustomLayerEbsVolumeArgs
import com.pulumi.aws.opsworks.kotlin.inputs.CustomLayerEbsVolumeArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.CustomLayerLoadBasedAutoScalingArgs
import com.pulumi.aws.opsworks.kotlin.inputs.CustomLayerLoadBasedAutoScalingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks custom layer resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.CustomLayer;
 * import com.pulumi.aws.opsworks.CustomLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var custlayer = new CustomLayer("custlayer", CustomLayerArgs.builder()
 *             .shortName("awesome")
 *             .stackId(aws_opsworks_stack.main().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpsWorks Custom Layers using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:opsworks/customLayer:CustomLayer bar 00000000-0000-0000-0000-000000000000
 * ```
 * @property autoAssignElasticIps Whether to automatically assign an elastic IP address to the layer's instances.
 * @property autoAssignPublicIps For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
 * @property autoHealing Whether to enable auto-healing for the layer.
 * @property cloudwatchConfiguration Will create an EBS volume and connect it to the layer's instances. See Cloudwatch Configuration.
 * @property customConfigureRecipes
 * @property customDeployRecipes
 * @property customInstanceProfileArn The ARN of an IAM profile that will be used for the layer's instances.
 * @property customJson Custom JSON attributes to apply to the layer.
 * @property customSecurityGroupIds Ids for a set of security groups to apply to the layer's instances.
 * @property customSetupRecipes
 * @property customShutdownRecipes
 * @property customUndeployRecipes
 * @property drainElbOnShutdown Whether to enable Elastic Load Balancing connection draining.
 * @property ebsVolumes Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
 * @property elasticLoadBalancer Name of an Elastic Load Balancer to attach to this layer
 * @property installUpdatesOnBoot Whether to install OS and package updates on each instance when it boots.
 * @property instanceShutdownTimeout The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
 * @property loadBasedAutoScaling Load-based auto scaling configuration. See Load Based AutoScaling
 * @property name A human-readable name for the layer.
 * @property shortName A short, machine-readable name for the layer, which will be used to identify it in the Chef node JSON.
 * @property stackId ID of the stack the layer will belong to.
 * @property systemPackages Names of a set of system packages to install on the layer's instances.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The following extra optional arguments, all lists of Chef recipe names, allow
 * custom Chef recipes to be applied to layer instances at the five different
 * lifecycle events, if custom cookbooks are enabled on the layer's stack:
 * @property useEbsOptimizedInstances Whether to use EBS-optimized instances.
 */
public data class CustomLayerArgs(
    public val autoAssignElasticIps: Output<Boolean>? = null,
    public val autoAssignPublicIps: Output<Boolean>? = null,
    public val autoHealing: Output<Boolean>? = null,
    public val cloudwatchConfiguration: Output<CustomLayerCloudwatchConfigurationArgs>? = null,
    public val customConfigureRecipes: Output<List<String>>? = null,
    public val customDeployRecipes: Output<List<String>>? = null,
    public val customInstanceProfileArn: Output<String>? = null,
    public val customJson: Output<String>? = null,
    public val customSecurityGroupIds: Output<List<String>>? = null,
    public val customSetupRecipes: Output<List<String>>? = null,
    public val customShutdownRecipes: Output<List<String>>? = null,
    public val customUndeployRecipes: Output<List<String>>? = null,
    public val drainElbOnShutdown: Output<Boolean>? = null,
    public val ebsVolumes: Output<List<CustomLayerEbsVolumeArgs>>? = null,
    public val elasticLoadBalancer: Output<String>? = null,
    public val installUpdatesOnBoot: Output<Boolean>? = null,
    public val instanceShutdownTimeout: Output<Int>? = null,
    public val loadBasedAutoScaling: Output<CustomLayerLoadBasedAutoScalingArgs>? = null,
    public val name: Output<String>? = null,
    public val shortName: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val systemPackages: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useEbsOptimizedInstances: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.CustomLayerArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.CustomLayerArgs =
        com.pulumi.aws.opsworks.CustomLayerArgs.builder()
            .autoAssignElasticIps(autoAssignElasticIps?.applyValue({ args0 -> args0 }))
            .autoAssignPublicIps(autoAssignPublicIps?.applyValue({ args0 -> args0 }))
            .autoHealing(autoHealing?.applyValue({ args0 -> args0 }))
            .cloudwatchConfiguration(
                cloudwatchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customConfigureRecipes(
                customConfigureRecipes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customDeployRecipes(customDeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customInstanceProfileArn(customInstanceProfileArn?.applyValue({ args0 -> args0 }))
            .customJson(customJson?.applyValue({ args0 -> args0 }))
            .customSecurityGroupIds(
                customSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customSetupRecipes(customSetupRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customShutdownRecipes(customShutdownRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customUndeployRecipes(customUndeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .drainElbOnShutdown(drainElbOnShutdown?.applyValue({ args0 -> args0 }))
            .ebsVolumes(
                ebsVolumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .elasticLoadBalancer(elasticLoadBalancer?.applyValue({ args0 -> args0 }))
            .installUpdatesOnBoot(installUpdatesOnBoot?.applyValue({ args0 -> args0 }))
            .instanceShutdownTimeout(instanceShutdownTimeout?.applyValue({ args0 -> args0 }))
            .loadBasedAutoScaling(
                loadBasedAutoScaling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .shortName(shortName?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .systemPackages(systemPackages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useEbsOptimizedInstances(useEbsOptimizedInstances?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLayerArgs].
 */
@PulumiTagMarker
public class CustomLayerArgsBuilder internal constructor() {
    private var autoAssignElasticIps: Output<Boolean>? = null

    private var autoAssignPublicIps: Output<Boolean>? = null

    private var autoHealing: Output<Boolean>? = null

    private var cloudwatchConfiguration: Output<CustomLayerCloudwatchConfigurationArgs>? = null

    private var customConfigureRecipes: Output<List<String>>? = null

    private var customDeployRecipes: Output<List<String>>? = null

    private var customInstanceProfileArn: Output<String>? = null

    private var customJson: Output<String>? = null

    private var customSecurityGroupIds: Output<List<String>>? = null

    private var customSetupRecipes: Output<List<String>>? = null

    private var customShutdownRecipes: Output<List<String>>? = null

    private var customUndeployRecipes: Output<List<String>>? = null

    private var drainElbOnShutdown: Output<Boolean>? = null

    private var ebsVolumes: Output<List<CustomLayerEbsVolumeArgs>>? = null

    private var elasticLoadBalancer: Output<String>? = null

    private var installUpdatesOnBoot: Output<Boolean>? = null

    private var instanceShutdownTimeout: Output<Int>? = null

    private var loadBasedAutoScaling: Output<CustomLayerLoadBasedAutoScalingArgs>? = null

    private var name: Output<String>? = null

    private var shortName: Output<String>? = null

    private var stackId: Output<String>? = null

    private var systemPackages: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useEbsOptimizedInstances: Output<Boolean>? = null

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("maroencwdendmgqo")
    public suspend fun autoAssignElasticIps(`value`: Output<Boolean>) {
        this.autoAssignElasticIps = value
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("qtmndnkegvkqxakl")
    public suspend fun autoAssignPublicIps(`value`: Output<Boolean>) {
        this.autoAssignPublicIps = value
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("hdohhgcdmetsuwfs")
    public suspend fun autoHealing(`value`: Output<Boolean>) {
        this.autoHealing = value
    }

    /**
     * @param value Will create an EBS volume and connect it to the layer's instances. See Cloudwatch Configuration.
     */
    @JvmName("twxrsyasqlyevqvl")
    public suspend
    fun cloudwatchConfiguration(`value`: Output<CustomLayerCloudwatchConfigurationArgs>) {
        this.cloudwatchConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("reyvtkkxhuxqshwc")
    public suspend fun customConfigureRecipes(`value`: Output<List<String>>) {
        this.customConfigureRecipes = value
    }

    @JvmName("eayrbbftpuakndef")
    public suspend fun customConfigureRecipes(vararg values: Output<String>) {
        this.customConfigureRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("riejnhthirusybre")
    public suspend fun customConfigureRecipes(values: List<Output<String>>) {
        this.customConfigureRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rqwegxbseunqdgcw")
    public suspend fun customDeployRecipes(`value`: Output<List<String>>) {
        this.customDeployRecipes = value
    }

    @JvmName("duvbcijovywtcvgp")
    public suspend fun customDeployRecipes(vararg values: Output<String>) {
        this.customDeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fdnobjhedqmbdmax")
    public suspend fun customDeployRecipes(values: List<Output<String>>) {
        this.customDeployRecipes = Output.all(values)
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("qfwmqwpnkcfbwqkw")
    public suspend fun customInstanceProfileArn(`value`: Output<String>) {
        this.customInstanceProfileArn = value
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("erxduldhktlhrcjg")
    public suspend fun customJson(`value`: Output<String>) {
        this.customJson = value
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("jyvgwaposlqfkmqx")
    public suspend fun customSecurityGroupIds(`value`: Output<List<String>>) {
        this.customSecurityGroupIds = value
    }

    @JvmName("djwalyhacjbptsug")
    public suspend fun customSecurityGroupIds(vararg values: Output<String>) {
        this.customSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("dlrpirivvbgfnrdl")
    public suspend fun customSecurityGroupIds(values: List<Output<String>>) {
        this.customSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ijxxmgnmpiobssdb")
    public suspend fun customSetupRecipes(`value`: Output<List<String>>) {
        this.customSetupRecipes = value
    }

    @JvmName("nvoxuqakbpjjdaop")
    public suspend fun customSetupRecipes(vararg values: Output<String>) {
        this.customSetupRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gwintctsridvybom")
    public suspend fun customSetupRecipes(values: List<Output<String>>) {
        this.customSetupRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("estvydmxhorhixfy")
    public suspend fun customShutdownRecipes(`value`: Output<List<String>>) {
        this.customShutdownRecipes = value
    }

    @JvmName("vurhjchdgntsdbwo")
    public suspend fun customShutdownRecipes(vararg values: Output<String>) {
        this.customShutdownRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jbqkqtokppgukdpp")
    public suspend fun customShutdownRecipes(values: List<Output<String>>) {
        this.customShutdownRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gxbljpleskstmgpo")
    public suspend fun customUndeployRecipes(`value`: Output<List<String>>) {
        this.customUndeployRecipes = value
    }

    @JvmName("pjqmujrokwtttssh")
    public suspend fun customUndeployRecipes(vararg values: Output<String>) {
        this.customUndeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rjcnsohlrrvganwd")
    public suspend fun customUndeployRecipes(values: List<Output<String>>) {
        this.customUndeployRecipes = Output.all(values)
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("idxjebkbhdpbfswe")
    public suspend fun drainElbOnShutdown(`value`: Output<Boolean>) {
        this.drainElbOnShutdown = value
    }

    /**
     * @param value Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
     */
    @JvmName("cylijdxtgvskmrqm")
    public suspend fun ebsVolumes(`value`: Output<List<CustomLayerEbsVolumeArgs>>) {
        this.ebsVolumes = value
    }

    @JvmName("bmsxdggpwmovdllx")
    public suspend fun ebsVolumes(vararg values: Output<CustomLayerEbsVolumeArgs>) {
        this.ebsVolumes = Output.all(values.asList())
    }

    /**
     * @param values Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
     */
    @JvmName("baoxofkwloakknlv")
    public suspend fun ebsVolumes(values: List<Output<CustomLayerEbsVolumeArgs>>) {
        this.ebsVolumes = Output.all(values)
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("tyfiueuetqjhscds")
    public suspend fun elasticLoadBalancer(`value`: Output<String>) {
        this.elasticLoadBalancer = value
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("hniarsaobmrfyufs")
    public suspend fun installUpdatesOnBoot(`value`: Output<Boolean>) {
        this.installUpdatesOnBoot = value
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("qahlhtmtblfvehhb")
    public suspend fun instanceShutdownTimeout(`value`: Output<Int>) {
        this.instanceShutdownTimeout = value
    }

    /**
     * @param value Load-based auto scaling configuration. See Load Based AutoScaling
     */
    @JvmName("swwrkiemgyqxwjex")
    public suspend fun loadBasedAutoScaling(`value`: Output<CustomLayerLoadBasedAutoScalingArgs>) {
        this.loadBasedAutoScaling = value
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("qpntwhgiusfffdqo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A short, machine-readable name for the layer, which will be used to identify it in the Chef node JSON.
     */
    @JvmName("gydwpbawdocthrsc")
    public suspend fun shortName(`value`: Output<String>) {
        this.shortName = value
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("lrvytlfqxkuonmfq")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("kyjivgqoouufwvkc")
    public suspend fun systemPackages(`value`: Output<List<String>>) {
        this.systemPackages = value
    }

    @JvmName("vjcoljqlteqhuhgc")
    public suspend fun systemPackages(vararg values: Output<String>) {
        this.systemPackages = Output.all(values.asList())
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("wfrxoskudwckmumb")
    public suspend fun systemPackages(values: List<Output<String>>) {
        this.systemPackages = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("poctuvwkuufituhy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("bwwvnvqsfnhkyxkx")
    public suspend fun useEbsOptimizedInstances(`value`: Output<Boolean>) {
        this.useEbsOptimizedInstances = value
    }

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("eswxetxbkgwujqjb")
    public suspend fun autoAssignElasticIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignElasticIps = mapped
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("envwvtiwwvnudtgl")
    public suspend fun autoAssignPublicIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignPublicIps = mapped
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("afopiyrmtgigfhyc")
    public suspend fun autoHealing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealing = mapped
    }

    /**
     * @param value Will create an EBS volume and connect it to the layer's instances. See Cloudwatch Configuration.
     */
    @JvmName("fufyguseowprroow")
    public suspend fun cloudwatchConfiguration(`value`: CustomLayerCloudwatchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param argument Will create an EBS volume and connect it to the layer's instances. See Cloudwatch Configuration.
     */
    @JvmName("ucthwhijrdcsccan")
    public suspend
    fun cloudwatchConfiguration(argument: suspend CustomLayerCloudwatchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLayerCloudwatchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("llpguaeksvxbvrej")
    public suspend fun customConfigureRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("umplypnpmnyxyiek")
    public suspend fun customConfigureRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("ymxyflucmdlwkkhr")
    public suspend fun customDeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("deuqfalwctltmvaw")
    public suspend fun customDeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("mtdjgvovpuuimntx")
    public suspend fun customInstanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customInstanceProfileArn = mapped
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("wduopswmcgujraff")
    public suspend fun customJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customJson = mapped
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("snksjdraubenrpfk")
    public suspend fun customSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("uqgjfcsbnovhxmpy")
    public suspend fun customSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("ronlopkaoyrawlhg")
    public suspend fun customSetupRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("kpdjsgvilgmbskiv")
    public suspend fun customSetupRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("llrqukbklirifnhm")
    public suspend fun customShutdownRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("jqdnlvxylrmgnmsh")
    public suspend fun customShutdownRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("squfeljdijnvbucu")
    public suspend fun customUndeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("vlfpxmdeahcpxwwm")
    public suspend fun customUndeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("cvnqtfkemskdxwnk")
    public suspend fun drainElbOnShutdown(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drainElbOnShutdown = mapped
    }

    /**
     * @param value Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
     */
    @JvmName("ioybxrwyiyvqoxeb")
    public suspend fun ebsVolumes(`value`: List<CustomLayerEbsVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param argument Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
     */
    @JvmName("xjkorafymewyqdtm")
    public suspend
    fun ebsVolumes(argument: List<suspend CustomLayerEbsVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
     */
    @JvmName("dgyjebakibofcaex")
    public suspend fun ebsVolumes(
        vararg
        argument: suspend CustomLayerEbsVolumeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
     */
    @JvmName("ngwwvvhgvniccuaf")
    public suspend fun ebsVolumes(argument: suspend CustomLayerEbsVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomLayerEbsVolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param values Will create an EBS volume and connect it to the layer's instances. See EBS Volume.
     */
    @JvmName("fqpdlnlwnkawshmu")
    public suspend fun ebsVolumes(vararg values: CustomLayerEbsVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("upctrokcpviihtuu")
    public suspend fun elasticLoadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticLoadBalancer = mapped
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("xtiiqxfteqwcdolq")
    public suspend fun installUpdatesOnBoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installUpdatesOnBoot = mapped
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("rrnudsdhtghrsskr")
    public suspend fun instanceShutdownTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceShutdownTimeout = mapped
    }

    /**
     * @param value Load-based auto scaling configuration. See Load Based AutoScaling
     */
    @JvmName("hwfrchvnhwjvxqct")
    public suspend fun loadBasedAutoScaling(`value`: CustomLayerLoadBasedAutoScalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param argument Load-based auto scaling configuration. See Load Based AutoScaling
     */
    @JvmName("urrjqjuoaugfesdy")
    public suspend
    fun loadBasedAutoScaling(argument: suspend CustomLayerLoadBasedAutoScalingArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLayerLoadBasedAutoScalingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("srtjhvcaupyayawi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A short, machine-readable name for the layer, which will be used to identify it in the Chef node JSON.
     */
    @JvmName("spgeyuvstukrldks")
    public suspend fun shortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shortName = mapped
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("psoboxqferokvlac")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("etdwvwqpgjxqqvpi")
    public suspend fun systemPackages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("benmbwceqdcigyic")
    public suspend fun systemPackages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("otmvsobemstnwsea")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("mdeigdvnlsloluxj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("iqvekntsnotbskli")
    public suspend fun useEbsOptimizedInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEbsOptimizedInstances = mapped
    }

    internal fun build(): CustomLayerArgs = CustomLayerArgs(
        autoAssignElasticIps = autoAssignElasticIps,
        autoAssignPublicIps = autoAssignPublicIps,
        autoHealing = autoHealing,
        cloudwatchConfiguration = cloudwatchConfiguration,
        customConfigureRecipes = customConfigureRecipes,
        customDeployRecipes = customDeployRecipes,
        customInstanceProfileArn = customInstanceProfileArn,
        customJson = customJson,
        customSecurityGroupIds = customSecurityGroupIds,
        customSetupRecipes = customSetupRecipes,
        customShutdownRecipes = customShutdownRecipes,
        customUndeployRecipes = customUndeployRecipes,
        drainElbOnShutdown = drainElbOnShutdown,
        ebsVolumes = ebsVolumes,
        elasticLoadBalancer = elasticLoadBalancer,
        installUpdatesOnBoot = installUpdatesOnBoot,
        instanceShutdownTimeout = instanceShutdownTimeout,
        loadBasedAutoScaling = loadBasedAutoScaling,
        name = name,
        shortName = shortName,
        stackId = stackId,
        systemPackages = systemPackages,
        tags = tags,
        useEbsOptimizedInstances = useEbsOptimizedInstances,
    )
}
