@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.EcsClusterLayerArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.EcsClusterLayerCloudwatchConfigurationArgs
import com.pulumi.aws.opsworks.kotlin.inputs.EcsClusterLayerCloudwatchConfigurationArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.EcsClusterLayerEbsVolumeArgs
import com.pulumi.aws.opsworks.kotlin.inputs.EcsClusterLayerEbsVolumeArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.EcsClusterLayerLoadBasedAutoScalingArgs
import com.pulumi.aws.opsworks.kotlin.inputs.EcsClusterLayerLoadBasedAutoScalingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks ECS Cluster layer resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.EcsClusterLayer;
 * import com.pulumi.aws.opsworks.EcsClusterLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EcsClusterLayer("example", EcsClusterLayerArgs.builder()
 *             .stackId(aws_opsworks_stack.example().id())
 *             .ecsClusterArn(aws_ecs_cluster.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * @property autoAssignElasticIps Whether to automatically assign an elastic IP address to the layer's instances.
 * @property autoAssignPublicIps For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
 * @property autoHealing Whether to enable auto-healing for the layer.
 * @property cloudwatchConfiguration
 * @property customConfigureRecipes
 * @property customDeployRecipes
 * @property customInstanceProfileArn The ARN of an IAM profile that will be used for the layer's instances.
 * @property customJson Custom JSON attributes to apply to the layer.
 * @property customSecurityGroupIds Ids for a set of security groups to apply to the layer's instances.
 * @property customSetupRecipes
 * @property customShutdownRecipes
 * @property customUndeployRecipes
 * @property drainElbOnShutdown Whether to enable Elastic Load Balancing connection draining.
 * @property ebsVolumes `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
 * @property ecsClusterArn The ECS Cluster ARN of the layer.
 * @property elasticLoadBalancer Name of an Elastic Load Balancer to attach to this layer
 * @property installUpdatesOnBoot Whether to install OS and package updates on each instance when it boots.
 * @property instanceShutdownTimeout The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
 * @property loadBasedAutoScaling
 * @property name A human-readable name for the layer.
 * @property stackId ID of the stack the layer will belong to.
 * @property systemPackages Names of a set of system packages to install on the layer's instances.
 * @property tags A mapping of tags to assign to the resource.
 * The following extra optional arguments, all lists of Chef recipe names, allow
 * custom Chef recipes to be applied to layer instances at the five different
 * lifecycle events, if custom cookbooks are enabled on the layer's stack:
 * @property useEbsOptimizedInstances Whether to use EBS-optimized instances.
 */
public data class EcsClusterLayerArgs(
    public val autoAssignElasticIps: Output<Boolean>? = null,
    public val autoAssignPublicIps: Output<Boolean>? = null,
    public val autoHealing: Output<Boolean>? = null,
    public val cloudwatchConfiguration: Output<EcsClusterLayerCloudwatchConfigurationArgs>? = null,
    public val customConfigureRecipes: Output<List<String>>? = null,
    public val customDeployRecipes: Output<List<String>>? = null,
    public val customInstanceProfileArn: Output<String>? = null,
    public val customJson: Output<String>? = null,
    public val customSecurityGroupIds: Output<List<String>>? = null,
    public val customSetupRecipes: Output<List<String>>? = null,
    public val customShutdownRecipes: Output<List<String>>? = null,
    public val customUndeployRecipes: Output<List<String>>? = null,
    public val drainElbOnShutdown: Output<Boolean>? = null,
    public val ebsVolumes: Output<List<EcsClusterLayerEbsVolumeArgs>>? = null,
    public val ecsClusterArn: Output<String>? = null,
    public val elasticLoadBalancer: Output<String>? = null,
    public val installUpdatesOnBoot: Output<Boolean>? = null,
    public val instanceShutdownTimeout: Output<Int>? = null,
    public val loadBasedAutoScaling: Output<EcsClusterLayerLoadBasedAutoScalingArgs>? = null,
    public val name: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val systemPackages: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useEbsOptimizedInstances: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.EcsClusterLayerArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.EcsClusterLayerArgs =
        com.pulumi.aws.opsworks.EcsClusterLayerArgs.builder()
            .autoAssignElasticIps(autoAssignElasticIps?.applyValue({ args0 -> args0 }))
            .autoAssignPublicIps(autoAssignPublicIps?.applyValue({ args0 -> args0 }))
            .autoHealing(autoHealing?.applyValue({ args0 -> args0 }))
            .cloudwatchConfiguration(
                cloudwatchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customConfigureRecipes(
                customConfigureRecipes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customDeployRecipes(customDeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customInstanceProfileArn(customInstanceProfileArn?.applyValue({ args0 -> args0 }))
            .customJson(customJson?.applyValue({ args0 -> args0 }))
            .customSecurityGroupIds(
                customSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customSetupRecipes(customSetupRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customShutdownRecipes(customShutdownRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customUndeployRecipes(customUndeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .drainElbOnShutdown(drainElbOnShutdown?.applyValue({ args0 -> args0 }))
            .ebsVolumes(
                ebsVolumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ecsClusterArn(ecsClusterArn?.applyValue({ args0 -> args0 }))
            .elasticLoadBalancer(elasticLoadBalancer?.applyValue({ args0 -> args0 }))
            .installUpdatesOnBoot(installUpdatesOnBoot?.applyValue({ args0 -> args0 }))
            .instanceShutdownTimeout(instanceShutdownTimeout?.applyValue({ args0 -> args0 }))
            .loadBasedAutoScaling(
                loadBasedAutoScaling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .systemPackages(systemPackages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useEbsOptimizedInstances(useEbsOptimizedInstances?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsClusterLayerArgs].
 */
@PulumiTagMarker
public class EcsClusterLayerArgsBuilder internal constructor() {
    private var autoAssignElasticIps: Output<Boolean>? = null

    private var autoAssignPublicIps: Output<Boolean>? = null

    private var autoHealing: Output<Boolean>? = null

    private var cloudwatchConfiguration: Output<EcsClusterLayerCloudwatchConfigurationArgs>? = null

    private var customConfigureRecipes: Output<List<String>>? = null

    private var customDeployRecipes: Output<List<String>>? = null

    private var customInstanceProfileArn: Output<String>? = null

    private var customJson: Output<String>? = null

    private var customSecurityGroupIds: Output<List<String>>? = null

    private var customSetupRecipes: Output<List<String>>? = null

    private var customShutdownRecipes: Output<List<String>>? = null

    private var customUndeployRecipes: Output<List<String>>? = null

    private var drainElbOnShutdown: Output<Boolean>? = null

    private var ebsVolumes: Output<List<EcsClusterLayerEbsVolumeArgs>>? = null

    private var ecsClusterArn: Output<String>? = null

    private var elasticLoadBalancer: Output<String>? = null

    private var installUpdatesOnBoot: Output<Boolean>? = null

    private var instanceShutdownTimeout: Output<Int>? = null

    private var loadBasedAutoScaling: Output<EcsClusterLayerLoadBasedAutoScalingArgs>? = null

    private var name: Output<String>? = null

    private var stackId: Output<String>? = null

    private var systemPackages: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useEbsOptimizedInstances: Output<Boolean>? = null

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("duepsbafphviwsbn")
    public suspend fun autoAssignElasticIps(`value`: Output<Boolean>) {
        this.autoAssignElasticIps = value
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("jdmlbalharqtegrm")
    public suspend fun autoAssignPublicIps(`value`: Output<Boolean>) {
        this.autoAssignPublicIps = value
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("hdmfqinmtiltskug")
    public suspend fun autoHealing(`value`: Output<Boolean>) {
        this.autoHealing = value
    }

    /**
     * @param value
     */
    @JvmName("myditokjdtbnxooc")
    public suspend
    fun cloudwatchConfiguration(`value`: Output<EcsClusterLayerCloudwatchConfigurationArgs>) {
        this.cloudwatchConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("jgklbguxvpdgnmvi")
    public suspend fun customConfigureRecipes(`value`: Output<List<String>>) {
        this.customConfigureRecipes = value
    }

    @JvmName("ogkadclvnjmoktgo")
    public suspend fun customConfigureRecipes(vararg values: Output<String>) {
        this.customConfigureRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("cbjvyxurtjkyygkw")
    public suspend fun customConfigureRecipes(values: List<Output<String>>) {
        this.customConfigureRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("breyokkulugxxpkt")
    public suspend fun customDeployRecipes(`value`: Output<List<String>>) {
        this.customDeployRecipes = value
    }

    @JvmName("bjebiqkqgmtsyqfr")
    public suspend fun customDeployRecipes(vararg values: Output<String>) {
        this.customDeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("lphupyreucehbubw")
    public suspend fun customDeployRecipes(values: List<Output<String>>) {
        this.customDeployRecipes = Output.all(values)
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("jgqywepihxmcwkbb")
    public suspend fun customInstanceProfileArn(`value`: Output<String>) {
        this.customInstanceProfileArn = value
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("ikcrghgnjdjkwkdu")
    public suspend fun customJson(`value`: Output<String>) {
        this.customJson = value
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("fxehblmoxffrjmdc")
    public suspend fun customSecurityGroupIds(`value`: Output<List<String>>) {
        this.customSecurityGroupIds = value
    }

    @JvmName("yvvpsqmefeqchjed")
    public suspend fun customSecurityGroupIds(vararg values: Output<String>) {
        this.customSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("wyvhyliwfyahkquv")
    public suspend fun customSecurityGroupIds(values: List<Output<String>>) {
        this.customSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rrkxsjonsyxcmwoa")
    public suspend fun customSetupRecipes(`value`: Output<List<String>>) {
        this.customSetupRecipes = value
    }

    @JvmName("afenvqtixuriihid")
    public suspend fun customSetupRecipes(vararg values: Output<String>) {
        this.customSetupRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nyvqorqubnootalp")
    public suspend fun customSetupRecipes(values: List<Output<String>>) {
        this.customSetupRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("magpmvxlegeeosmq")
    public suspend fun customShutdownRecipes(`value`: Output<List<String>>) {
        this.customShutdownRecipes = value
    }

    @JvmName("jgojjehmwxavvvdn")
    public suspend fun customShutdownRecipes(vararg values: Output<String>) {
        this.customShutdownRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("laxeigrgjwsvqphc")
    public suspend fun customShutdownRecipes(values: List<Output<String>>) {
        this.customShutdownRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dtdqrcvvxtcovdtd")
    public suspend fun customUndeployRecipes(`value`: Output<List<String>>) {
        this.customUndeployRecipes = value
    }

    @JvmName("lshonanflovjigcr")
    public suspend fun customUndeployRecipes(vararg values: Output<String>) {
        this.customUndeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wusxagfostufamxg")
    public suspend fun customUndeployRecipes(values: List<Output<String>>) {
        this.customUndeployRecipes = Output.all(values)
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("gdjypfapkoyjkpgp")
    public suspend fun drainElbOnShutdown(`value`: Output<Boolean>) {
        this.drainElbOnShutdown = value
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("vlweikpikxmdyfwm")
    public suspend fun ebsVolumes(`value`: Output<List<EcsClusterLayerEbsVolumeArgs>>) {
        this.ebsVolumes = value
    }

    @JvmName("uwinjduyltcljwtu")
    public suspend fun ebsVolumes(vararg values: Output<EcsClusterLayerEbsVolumeArgs>) {
        this.ebsVolumes = Output.all(values.asList())
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("hiyqlnplobseyvdt")
    public suspend fun ebsVolumes(values: List<Output<EcsClusterLayerEbsVolumeArgs>>) {
        this.ebsVolumes = Output.all(values)
    }

    /**
     * @param value The ECS Cluster ARN of the layer.
     */
    @JvmName("enroshvqijpmidka")
    public suspend fun ecsClusterArn(`value`: Output<String>) {
        this.ecsClusterArn = value
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("ghsrdwynauvjbgkt")
    public suspend fun elasticLoadBalancer(`value`: Output<String>) {
        this.elasticLoadBalancer = value
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("ggexyedafhubffjn")
    public suspend fun installUpdatesOnBoot(`value`: Output<Boolean>) {
        this.installUpdatesOnBoot = value
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("xrujotuvkoasnrni")
    public suspend fun instanceShutdownTimeout(`value`: Output<Int>) {
        this.instanceShutdownTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("yvnqhuwhhynprouc")
    public suspend
    fun loadBasedAutoScaling(`value`: Output<EcsClusterLayerLoadBasedAutoScalingArgs>) {
        this.loadBasedAutoScaling = value
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("pwugnpiooudmxkel")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("pbocwhtdpxxikyra")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("vllbohtjyormemyr")
    public suspend fun systemPackages(`value`: Output<List<String>>) {
        this.systemPackages = value
    }

    @JvmName("fpbavyimjvipcifl")
    public suspend fun systemPackages(vararg values: Output<String>) {
        this.systemPackages = Output.all(values.asList())
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("ahqpvgststopukib")
    public suspend fun systemPackages(values: List<Output<String>>) {
        this.systemPackages = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("unhbeyfkwpbtgbbn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("xbkovjqbifjrvhsh")
    public suspend fun useEbsOptimizedInstances(`value`: Output<Boolean>) {
        this.useEbsOptimizedInstances = value
    }

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("yngptwojibqjryvh")
    public suspend fun autoAssignElasticIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignElasticIps = mapped
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("vypfptcavfhundml")
    public suspend fun autoAssignPublicIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignPublicIps = mapped
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("pwfhwgmorepwgxjx")
    public suspend fun autoHealing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealing = mapped
    }

    /**
     * @param value
     */
    @JvmName("axixjgjiykmmjeca")
    public suspend fun cloudwatchConfiguration(`value`: EcsClusterLayerCloudwatchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tahdqjigltbdduqb")
    public suspend
    fun cloudwatchConfiguration(argument: suspend EcsClusterLayerCloudwatchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = EcsClusterLayerCloudwatchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("bbnnsvmutcuhrwrc")
    public suspend fun customConfigureRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("yenfhgxtyvvvvnop")
    public suspend fun customConfigureRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("kwvmawnbuysauyuw")
    public suspend fun customDeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("kicdnfxtlokkyuso")
    public suspend fun customDeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("kngqubdasujoydhr")
    public suspend fun customInstanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customInstanceProfileArn = mapped
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("xvwwsntwsolwchtf")
    public suspend fun customJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customJson = mapped
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("iwlfsonafmyyvaes")
    public suspend fun customSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("qdouekyhjhfbghwb")
    public suspend fun customSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("idkjbkwdndkxpwcs")
    public suspend fun customSetupRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("iigbllggkqamwqiv")
    public suspend fun customSetupRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("rkteuponxlvnkejh")
    public suspend fun customShutdownRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("iihveganoygddigx")
    public suspend fun customShutdownRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("rsqommpgmvcbovcm")
    public suspend fun customUndeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("ahgepwacmloikrin")
    public suspend fun customUndeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("xjfcwxvhnpygsgcm")
    public suspend fun drainElbOnShutdown(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drainElbOnShutdown = mapped
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("wynrdebpkrbrvnhg")
    public suspend fun ebsVolumes(`value`: List<EcsClusterLayerEbsVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("qljxjqyoqlsqwctd")
    public suspend
    fun ebsVolumes(argument: List<suspend EcsClusterLayerEbsVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EcsClusterLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("otmumedgdxgfdown")
    public suspend fun ebsVolumes(
        vararg
        argument: suspend EcsClusterLayerEbsVolumeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EcsClusterLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("tkvhkygosbuhlaks")
    public suspend fun ebsVolumes(argument: suspend EcsClusterLayerEbsVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EcsClusterLayerEbsVolumeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("psuxljnvckvunhfd")
    public suspend fun ebsVolumes(vararg values: EcsClusterLayerEbsVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param value The ECS Cluster ARN of the layer.
     */
    @JvmName("apcqhbfaxwoussnb")
    public suspend fun ecsClusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsClusterArn = mapped
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("xxnhqmopmyycaqgj")
    public suspend fun elasticLoadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticLoadBalancer = mapped
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("aliwekhaunkbicjw")
    public suspend fun installUpdatesOnBoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installUpdatesOnBoot = mapped
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("rinsicbgoixonrbp")
    public suspend fun instanceShutdownTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceShutdownTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("jcfypbetpiqfcxra")
    public suspend fun loadBasedAutoScaling(`value`: EcsClusterLayerLoadBasedAutoScalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xgffrwdwbtckloal")
    public suspend
    fun loadBasedAutoScaling(argument: suspend EcsClusterLayerLoadBasedAutoScalingArgsBuilder.() -> Unit) {
        val toBeMapped = EcsClusterLayerLoadBasedAutoScalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("qrblmuohimyevaim")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("ttdovlyejooukiky")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("axbeylhevwsiskpy")
    public suspend fun systemPackages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("mgqwtxcjfhmuhltc")
    public suspend fun systemPackages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("bnciodlosbchjxqm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("fjkkbjjwcclfyuus")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("dydwgoogvalpakdr")
    public suspend fun useEbsOptimizedInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEbsOptimizedInstances = mapped
    }

    internal fun build(): EcsClusterLayerArgs = EcsClusterLayerArgs(
        autoAssignElasticIps = autoAssignElasticIps,
        autoAssignPublicIps = autoAssignPublicIps,
        autoHealing = autoHealing,
        cloudwatchConfiguration = cloudwatchConfiguration,
        customConfigureRecipes = customConfigureRecipes,
        customDeployRecipes = customDeployRecipes,
        customInstanceProfileArn = customInstanceProfileArn,
        customJson = customJson,
        customSecurityGroupIds = customSecurityGroupIds,
        customSetupRecipes = customSetupRecipes,
        customShutdownRecipes = customShutdownRecipes,
        customUndeployRecipes = customUndeployRecipes,
        drainElbOnShutdown = drainElbOnShutdown,
        ebsVolumes = ebsVolumes,
        ecsClusterArn = ecsClusterArn,
        elasticLoadBalancer = elasticLoadBalancer,
        installUpdatesOnBoot = installUpdatesOnBoot,
        instanceShutdownTimeout = instanceShutdownTimeout,
        loadBasedAutoScaling = loadBasedAutoScaling,
        name = name,
        stackId = stackId,
        systemPackages = systemPackages,
        tags = tags,
        useEbsOptimizedInstances = useEbsOptimizedInstances,
    )
}
