@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.kotlin.outputs.InstanceEbsBlockDevice
import com.pulumi.aws.opsworks.kotlin.outputs.InstanceEphemeralBlockDevice
import com.pulumi.aws.opsworks.kotlin.outputs.InstanceRootBlockDevice
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.opsworks.kotlin.outputs.InstanceEbsBlockDevice.Companion.toKotlin as instanceEbsBlockDeviceToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.InstanceEphemeralBlockDevice.Companion.toKotlin as instanceEphemeralBlockDeviceToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.InstanceRootBlockDevice.Companion.toKotlin as instanceRootBlockDeviceToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.aws.opsworks.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks instance resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Instance;
 * import com.pulumi.aws.opsworks.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var my_instance = new Instance("my-instance", InstanceArgs.builder()
 *             .stackId(aws_opsworks_stack.main().id())
 *             .layerIds(aws_opsworks_custom_layer.my-layer().id())
 *             .instanceType("t2.micro")
 *             .os("Amazon Linux 2015.09")
 *             .state("stopped")
 *             .build());
 *     }
 * }
 * ```
 * ## Block devices
 * Each of the `*_block_device` attributes controls a portion of the AWS
 * Instance's "Block Device Mapping". It's a good idea to familiarize yourself with [AWS's Block Device
 * Mapping docs](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
 * to understand the implications of using these attributes.
 * ### `ebs_block_device`
 * * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
 * * `device_name` - (Required) Name of the device to mount.
 * * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
 * * `snapshot_id` - (Optional) Snapshot ID to mount.
 * * `volume_size` - (Optional) Size of the volume in gigabytes.
 * * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.
 * Modifying any `ebs_block_device` currently requires resource replacement.
 * ### `ephemeral_block_device`
 * * `device_name` - Name of the block device to mount on the instance.
 * * `virtual_name` - The [Instance Store Device Name](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).
 * Each AWS Instance type has a different set of Instance Store block devices
 * available for attachment. AWS [publishes a
 * list](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes)
 * of which ephemeral devices are available on each type. The devices are always
 * identified by the `virtual_name` in the format `ephemeral{0..N}`.
 * ### `root_block_device`
 * * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
 * * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
 * * `volume_size` - (Optional) Size of the volume in gigabytes.
 * * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.
 * Modifying any of the `root_block_device` settings requires resource
 * replacement.
 * > **NOTE:** Currently, changes to `*_block_device` configuration of _existing_
 * resources cannot be automatically detected by this provider. After making updates
 * to block device configuration, resource recreation can be manually triggered by
 * using the [`up` command with the --replace argument](https://www.pulumi.com/docs/reference/cli/pulumi_up/).
 * ## Import
 * Using `pulumi import`, import Opsworks Instances using the instance `id`. For example:
 * ```sh
 *  $ pulumi import aws:opsworks/instance:Instance my_instance 4d6d1710-ded9-42a1-b08e-b043ad7af1e2
 * ```
 *
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * OpsWorks agent to install. Default is `INHERIT`.
     */
    public val agentVersion: Output<String>?
        get() = javaResource.agentVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
     */
    public val amiId: Output<String>
        get() = javaResource.amiId().applyValue({ args0 -> args0 })

    /**
     * Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
     */
    public val architecture: Output<String>?
        get() = javaResource.architecture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Creates load-based or time-based instances.  Valid values are `load`, `timer`.
     */
    public val autoScalingType: Output<String>?
        get() = javaResource.autoScalingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the availability zone where instances will be created by default.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Time that the instance was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Whether to delete EBS volume on deletion. Default is `true`.
     */
    public val deleteEbs: Output<Boolean>?
        get() = javaResource.deleteEbs().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to delete the Elastic IP on deletion.
     */
    public val deleteEip: Output<Boolean>?
        get() = javaResource.deleteEip().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     */
    public val ebsBlockDevices: Output<List<InstanceEbsBlockDevice>>
        get() = javaResource.ebsBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceEbsBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * Whether the launched EC2 instance will be EBS-optimized.
     */
    public val ebsOptimized: Output<Boolean>?
        get() = javaResource.ebsOptimized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * EC2 instance ID.
     */
    public val ec2InstanceId: Output<String>
        get() = javaResource.ec2InstanceId().applyValue({ args0 -> args0 })

    /**
     * ECS cluster's ARN for container instances.
     */
    public val ecsClusterArn: Output<String>
        get() = javaResource.ecsClusterArn().applyValue({ args0 -> args0 })

    /**
     * Instance Elastic IP address.
     */
    public val elasticIp: Output<String>
        get() = javaResource.elasticIp().applyValue({ args0 -> args0 })

    /**
     * Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
     */
    public val ephemeralBlockDevices: Output<List<InstanceEphemeralBlockDevice>>
        get() = javaResource.ephemeralBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceEphemeralBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * Instance's host name.
     */
    public val hostname: Output<String>
        get() = javaResource.hostname().applyValue({ args0 -> args0 })

    /**
     * For registered instances, infrastructure class: ec2 or on-premises.
     */
    public val infrastructureClass: Output<String>
        get() = javaResource.infrastructureClass().applyValue({ args0 -> args0 })

    /**
     * Controls where to install OS and package updates when the instance boots.  Default is `true`.
     */
    public val installUpdatesOnBoot: Output<Boolean>?
        get() = javaResource.installUpdatesOnBoot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the instance's IAM profile.
     */
    public val instanceProfileArn: Output<String>
        get() = javaResource.instanceProfileArn().applyValue({ args0 -> args0 })

    /**
     * Type of instance to start.
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the last service error.
     */
    public val lastServiceErrorId: Output<String>
        get() = javaResource.lastServiceErrorId().applyValue({ args0 -> args0 })

    /**
     * List of the layers the instance will belong to.
     */
    public val layerIds: Output<List<String>>
        get() = javaResource.layerIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Name of operating system that will be installed.
     */
    public val os: Output<String>
        get() = javaResource.os().applyValue({ args0 -> args0 })

    /**
     * Instance's platform.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
     */
    public val privateDns: Output<String>
        get() = javaResource.privateDns().applyValue({ args0 -> args0 })

    /**
     * Private IP address assigned to the instance.
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
     */
    public val publicDns: Output<String>
        get() = javaResource.publicDns().applyValue({ args0 -> args0 })

    /**
     * Public IP address assigned to the instance, if applicable.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })

    /**
     * For registered instances, who performed the registration.
     */
    public val registeredBy: Output<String>
        get() = javaResource.registeredBy().applyValue({ args0 -> args0 })

    /**
     * Instance's reported AWS OpsWorks Stacks agent version.
     */
    public val reportedAgentVersion: Output<String>
        get() = javaResource.reportedAgentVersion().applyValue({ args0 -> args0 })

    /**
     * For registered instances, the reported operating system family.
     */
    public val reportedOsFamily: Output<String>
        get() = javaResource.reportedOsFamily().applyValue({ args0 -> args0 })

    /**
     * For registered instances, the reported operating system name.
     */
    public val reportedOsName: Output<String>
        get() = javaResource.reportedOsName().applyValue({ args0 -> args0 })

    /**
     * For registered instances, the reported operating system version.
     */
    public val reportedOsVersion: Output<String>
        get() = javaResource.reportedOsVersion().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the root block device of the instance. See Block Devices below.
     */
    public val rootBlockDevices: Output<List<InstanceRootBlockDevice>>
        get() = javaResource.rootBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceRootBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
     */
    public val rootDeviceType: Output<String>
        get() = javaResource.rootDeviceType().applyValue({ args0 -> args0 })

    /**
     * Root device volume ID.
     */
    public val rootDeviceVolumeId: Output<String>
        get() = javaResource.rootDeviceVolumeId().applyValue({ args0 -> args0 })

    /**
     * Associated security groups.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * SSH key's Deep Security Agent (DSA) fingerprint.
     */
    public val sshHostDsaKeyFingerprint: Output<String>
        get() = javaResource.sshHostDsaKeyFingerprint().applyValue({ args0 -> args0 })

    /**
     * SSH key's RSA fingerprint.
     */
    public val sshHostRsaKeyFingerprint: Output<String>
        get() = javaResource.sshHostRsaKeyFingerprint().applyValue({ args0 -> args0 })

    /**
     * Name of the SSH keypair that instances will have by default.
     */
    public val sshKeyName: Output<String>
        get() = javaResource.sshKeyName().applyValue({ args0 -> args0 })

    /**
     * Identifier of the stack the instance will belong to.
     * The following arguments are optional:
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * Desired state of the instance. Valid values are `running` or `stopped`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Subnet ID to attach to.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
     */
    public val tenancy: Output<String>
        get() = javaResource.tenancy().applyValue({ args0 -> args0 })

    /**
     * Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
     */
    public val virtualizationType: Output<String>
        get() = javaResource.virtualizationType().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.aws.opsworks.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit):
    Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
