@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.JavaAppLayerArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.JavaAppLayerCloudwatchConfigurationArgs
import com.pulumi.aws.opsworks.kotlin.inputs.JavaAppLayerCloudwatchConfigurationArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.JavaAppLayerEbsVolumeArgs
import com.pulumi.aws.opsworks.kotlin.inputs.JavaAppLayerEbsVolumeArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.JavaAppLayerLoadBasedAutoScalingArgs
import com.pulumi.aws.opsworks.kotlin.inputs.JavaAppLayerLoadBasedAutoScalingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks Java application layer resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.JavaAppLayer;
 * import com.pulumi.aws.opsworks.JavaAppLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new JavaAppLayer("app", JavaAppLayerArgs.builder()
 *             .stackId(aws_opsworks_stack.main().id())
 *             .build());
 *     }
 * }
 * ```
 * @property appServer Keyword for the application container to use. Defaults to "tomcat".
 * @property appServerVersion Version of the selected application container to use. Defaults to "7".
 * @property autoAssignElasticIps Whether to automatically assign an elastic IP address to the layer's instances.
 * @property autoAssignPublicIps For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
 * @property autoHealing Whether to enable auto-healing for the layer.
 * @property cloudwatchConfiguration
 * @property customConfigureRecipes
 * @property customDeployRecipes
 * @property customInstanceProfileArn The ARN of an IAM profile that will be used for the layer's instances.
 * @property customJson Custom JSON attributes to apply to the layer.
 * @property customSecurityGroupIds Ids for a set of security groups to apply to the layer's instances.
 * @property customSetupRecipes
 * @property customShutdownRecipes
 * @property customUndeployRecipes
 * @property drainElbOnShutdown Whether to enable Elastic Load Balancing connection draining.
 * @property ebsVolumes `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
 * @property elasticLoadBalancer Name of an Elastic Load Balancer to attach to this layer
 * @property installUpdatesOnBoot Whether to install OS and package updates on each instance when it boots.
 * @property instanceShutdownTimeout The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
 * @property jvmOptions Options to set for the JVM.
 * @property jvmType Keyword for the type of JVM to use. Defaults to `openjdk`.
 * @property jvmVersion Version of JVM to use. Defaults to "7".
 * @property loadBasedAutoScaling
 * @property name A human-readable name for the layer.
 * @property stackId ID of the stack the layer will belong to.
 * @property systemPackages Names of a set of system packages to install on the layer's instances.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The following extra optional arguments, all lists of Chef recipe names, allow
 * custom Chef recipes to be applied to layer instances at the five different
 * lifecycle events, if custom cookbooks are enabled on the layer's stack:
 * @property useEbsOptimizedInstances Whether to use EBS-optimized instances.
 */
public data class JavaAppLayerArgs(
    public val appServer: Output<String>? = null,
    public val appServerVersion: Output<String>? = null,
    public val autoAssignElasticIps: Output<Boolean>? = null,
    public val autoAssignPublicIps: Output<Boolean>? = null,
    public val autoHealing: Output<Boolean>? = null,
    public val cloudwatchConfiguration: Output<JavaAppLayerCloudwatchConfigurationArgs>? = null,
    public val customConfigureRecipes: Output<List<String>>? = null,
    public val customDeployRecipes: Output<List<String>>? = null,
    public val customInstanceProfileArn: Output<String>? = null,
    public val customJson: Output<String>? = null,
    public val customSecurityGroupIds: Output<List<String>>? = null,
    public val customSetupRecipes: Output<List<String>>? = null,
    public val customShutdownRecipes: Output<List<String>>? = null,
    public val customUndeployRecipes: Output<List<String>>? = null,
    public val drainElbOnShutdown: Output<Boolean>? = null,
    public val ebsVolumes: Output<List<JavaAppLayerEbsVolumeArgs>>? = null,
    public val elasticLoadBalancer: Output<String>? = null,
    public val installUpdatesOnBoot: Output<Boolean>? = null,
    public val instanceShutdownTimeout: Output<Int>? = null,
    public val jvmOptions: Output<String>? = null,
    public val jvmType: Output<String>? = null,
    public val jvmVersion: Output<String>? = null,
    public val loadBasedAutoScaling: Output<JavaAppLayerLoadBasedAutoScalingArgs>? = null,
    public val name: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val systemPackages: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useEbsOptimizedInstances: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.JavaAppLayerArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.JavaAppLayerArgs =
        com.pulumi.aws.opsworks.JavaAppLayerArgs.builder()
            .appServer(appServer?.applyValue({ args0 -> args0 }))
            .appServerVersion(appServerVersion?.applyValue({ args0 -> args0 }))
            .autoAssignElasticIps(autoAssignElasticIps?.applyValue({ args0 -> args0 }))
            .autoAssignPublicIps(autoAssignPublicIps?.applyValue({ args0 -> args0 }))
            .autoHealing(autoHealing?.applyValue({ args0 -> args0 }))
            .cloudwatchConfiguration(
                cloudwatchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customConfigureRecipes(
                customConfigureRecipes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customDeployRecipes(customDeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customInstanceProfileArn(customInstanceProfileArn?.applyValue({ args0 -> args0 }))
            .customJson(customJson?.applyValue({ args0 -> args0 }))
            .customSecurityGroupIds(
                customSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customSetupRecipes(customSetupRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customShutdownRecipes(customShutdownRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customUndeployRecipes(customUndeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .drainElbOnShutdown(drainElbOnShutdown?.applyValue({ args0 -> args0 }))
            .ebsVolumes(
                ebsVolumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .elasticLoadBalancer(elasticLoadBalancer?.applyValue({ args0 -> args0 }))
            .installUpdatesOnBoot(installUpdatesOnBoot?.applyValue({ args0 -> args0 }))
            .instanceShutdownTimeout(instanceShutdownTimeout?.applyValue({ args0 -> args0 }))
            .jvmOptions(jvmOptions?.applyValue({ args0 -> args0 }))
            .jvmType(jvmType?.applyValue({ args0 -> args0 }))
            .jvmVersion(jvmVersion?.applyValue({ args0 -> args0 }))
            .loadBasedAutoScaling(
                loadBasedAutoScaling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .systemPackages(systemPackages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useEbsOptimizedInstances(useEbsOptimizedInstances?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JavaAppLayerArgs].
 */
@PulumiTagMarker
public class JavaAppLayerArgsBuilder internal constructor() {
    private var appServer: Output<String>? = null

    private var appServerVersion: Output<String>? = null

    private var autoAssignElasticIps: Output<Boolean>? = null

    private var autoAssignPublicIps: Output<Boolean>? = null

    private var autoHealing: Output<Boolean>? = null

    private var cloudwatchConfiguration: Output<JavaAppLayerCloudwatchConfigurationArgs>? = null

    private var customConfigureRecipes: Output<List<String>>? = null

    private var customDeployRecipes: Output<List<String>>? = null

    private var customInstanceProfileArn: Output<String>? = null

    private var customJson: Output<String>? = null

    private var customSecurityGroupIds: Output<List<String>>? = null

    private var customSetupRecipes: Output<List<String>>? = null

    private var customShutdownRecipes: Output<List<String>>? = null

    private var customUndeployRecipes: Output<List<String>>? = null

    private var drainElbOnShutdown: Output<Boolean>? = null

    private var ebsVolumes: Output<List<JavaAppLayerEbsVolumeArgs>>? = null

    private var elasticLoadBalancer: Output<String>? = null

    private var installUpdatesOnBoot: Output<Boolean>? = null

    private var instanceShutdownTimeout: Output<Int>? = null

    private var jvmOptions: Output<String>? = null

    private var jvmType: Output<String>? = null

    private var jvmVersion: Output<String>? = null

    private var loadBasedAutoScaling: Output<JavaAppLayerLoadBasedAutoScalingArgs>? = null

    private var name: Output<String>? = null

    private var stackId: Output<String>? = null

    private var systemPackages: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useEbsOptimizedInstances: Output<Boolean>? = null

    /**
     * @param value Keyword for the application container to use. Defaults to "tomcat".
     */
    @JvmName("yjljcpmlfipiqspp")
    public suspend fun appServer(`value`: Output<String>) {
        this.appServer = value
    }

    /**
     * @param value Version of the selected application container to use. Defaults to "7".
     */
    @JvmName("srrmtfkatvosrnlt")
    public suspend fun appServerVersion(`value`: Output<String>) {
        this.appServerVersion = value
    }

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("tkjstgyanrfehjil")
    public suspend fun autoAssignElasticIps(`value`: Output<Boolean>) {
        this.autoAssignElasticIps = value
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("gtxkwtjhjxawqdst")
    public suspend fun autoAssignPublicIps(`value`: Output<Boolean>) {
        this.autoAssignPublicIps = value
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("xwxpnwebnouxagaj")
    public suspend fun autoHealing(`value`: Output<Boolean>) {
        this.autoHealing = value
    }

    /**
     * @param value
     */
    @JvmName("qodrpoemkffeohrm")
    public suspend
    fun cloudwatchConfiguration(`value`: Output<JavaAppLayerCloudwatchConfigurationArgs>) {
        this.cloudwatchConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("phcqekulslkkrcbk")
    public suspend fun customConfigureRecipes(`value`: Output<List<String>>) {
        this.customConfigureRecipes = value
    }

    @JvmName("pypandriihrmjyyl")
    public suspend fun customConfigureRecipes(vararg values: Output<String>) {
        this.customConfigureRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("acwkxxjgwbasajfg")
    public suspend fun customConfigureRecipes(values: List<Output<String>>) {
        this.customConfigureRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ybbgynvfjckeimei")
    public suspend fun customDeployRecipes(`value`: Output<List<String>>) {
        this.customDeployRecipes = value
    }

    @JvmName("wndmjyxjevhqgdxl")
    public suspend fun customDeployRecipes(vararg values: Output<String>) {
        this.customDeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("aqripnowtspnxtoh")
    public suspend fun customDeployRecipes(values: List<Output<String>>) {
        this.customDeployRecipes = Output.all(values)
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("paganydkchfhwiih")
    public suspend fun customInstanceProfileArn(`value`: Output<String>) {
        this.customInstanceProfileArn = value
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("svtgdgjahbcxwnve")
    public suspend fun customJson(`value`: Output<String>) {
        this.customJson = value
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("pknjkhanvaeanyrh")
    public suspend fun customSecurityGroupIds(`value`: Output<List<String>>) {
        this.customSecurityGroupIds = value
    }

    @JvmName("wrupjgpbvsshfhpx")
    public suspend fun customSecurityGroupIds(vararg values: Output<String>) {
        this.customSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("tvjyfcqrchrtkdwo")
    public suspend fun customSecurityGroupIds(values: List<Output<String>>) {
        this.customSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("spghagoonnqgaygp")
    public suspend fun customSetupRecipes(`value`: Output<List<String>>) {
        this.customSetupRecipes = value
    }

    @JvmName("slufqvtsmhiaqqli")
    public suspend fun customSetupRecipes(vararg values: Output<String>) {
        this.customSetupRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jmxtmmtcmwumvlqw")
    public suspend fun customSetupRecipes(values: List<Output<String>>) {
        this.customSetupRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("konrjbgbhfillujt")
    public suspend fun customShutdownRecipes(`value`: Output<List<String>>) {
        this.customShutdownRecipes = value
    }

    @JvmName("lhlrrdjkhdquebio")
    public suspend fun customShutdownRecipes(vararg values: Output<String>) {
        this.customShutdownRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ckhjbjdktjhsuiqr")
    public suspend fun customShutdownRecipes(values: List<Output<String>>) {
        this.customShutdownRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("pbkhtiqbghlsvvji")
    public suspend fun customUndeployRecipes(`value`: Output<List<String>>) {
        this.customUndeployRecipes = value
    }

    @JvmName("rnxjruktjhmpbicj")
    public suspend fun customUndeployRecipes(vararg values: Output<String>) {
        this.customUndeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("udpugatvcdvknnkx")
    public suspend fun customUndeployRecipes(values: List<Output<String>>) {
        this.customUndeployRecipes = Output.all(values)
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("eewnsalmpnrvmcut")
    public suspend fun drainElbOnShutdown(`value`: Output<Boolean>) {
        this.drainElbOnShutdown = value
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("mbxlmgguotrhvcyc")
    public suspend fun ebsVolumes(`value`: Output<List<JavaAppLayerEbsVolumeArgs>>) {
        this.ebsVolumes = value
    }

    @JvmName("eouneiduaqvmpyxm")
    public suspend fun ebsVolumes(vararg values: Output<JavaAppLayerEbsVolumeArgs>) {
        this.ebsVolumes = Output.all(values.asList())
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("uqtricwaulrfrsgs")
    public suspend fun ebsVolumes(values: List<Output<JavaAppLayerEbsVolumeArgs>>) {
        this.ebsVolumes = Output.all(values)
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("mmyvjyhhaiovqpdo")
    public suspend fun elasticLoadBalancer(`value`: Output<String>) {
        this.elasticLoadBalancer = value
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("msmbvvitktmywvyn")
    public suspend fun installUpdatesOnBoot(`value`: Output<Boolean>) {
        this.installUpdatesOnBoot = value
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("pndufycjciddscom")
    public suspend fun instanceShutdownTimeout(`value`: Output<Int>) {
        this.instanceShutdownTimeout = value
    }

    /**
     * @param value Options to set for the JVM.
     */
    @JvmName("kjtvvrfpcadujunc")
    public suspend fun jvmOptions(`value`: Output<String>) {
        this.jvmOptions = value
    }

    /**
     * @param value Keyword for the type of JVM to use. Defaults to `openjdk`.
     */
    @JvmName("ebqkichntmpyibww")
    public suspend fun jvmType(`value`: Output<String>) {
        this.jvmType = value
    }

    /**
     * @param value Version of JVM to use. Defaults to "7".
     */
    @JvmName("gwdcyhwotvqpsbrm")
    public suspend fun jvmVersion(`value`: Output<String>) {
        this.jvmVersion = value
    }

    /**
     * @param value
     */
    @JvmName("hgfvwlvbsakjwelm")
    public suspend fun loadBasedAutoScaling(`value`: Output<JavaAppLayerLoadBasedAutoScalingArgs>) {
        this.loadBasedAutoScaling = value
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("ojagtnjycthaasjs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("tdbchxwxmqecfdnk")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("nafbmaeapijwhpni")
    public suspend fun systemPackages(`value`: Output<List<String>>) {
        this.systemPackages = value
    }

    @JvmName("aqpiofnbvopiuclp")
    public suspend fun systemPackages(vararg values: Output<String>) {
        this.systemPackages = Output.all(values.asList())
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("chsqxjsynvrgyrve")
    public suspend fun systemPackages(values: List<Output<String>>) {
        this.systemPackages = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("ignplvhswvokjbom")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("miyexyvkbohwbwvq")
    public suspend fun useEbsOptimizedInstances(`value`: Output<Boolean>) {
        this.useEbsOptimizedInstances = value
    }

    /**
     * @param value Keyword for the application container to use. Defaults to "tomcat".
     */
    @JvmName("xgyxqpgwjatwrggr")
    public suspend fun appServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appServer = mapped
    }

    /**
     * @param value Version of the selected application container to use. Defaults to "7".
     */
    @JvmName("wgglgnjcextlqppu")
    public suspend fun appServerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appServerVersion = mapped
    }

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("eyvynmjixaelxklh")
    public suspend fun autoAssignElasticIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignElasticIps = mapped
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("cwcfiypbvsdceccu")
    public suspend fun autoAssignPublicIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignPublicIps = mapped
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("eiombuggjsbfnktk")
    public suspend fun autoHealing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealing = mapped
    }

    /**
     * @param value
     */
    @JvmName("jtxguwviyieqygwm")
    public suspend fun cloudwatchConfiguration(`value`: JavaAppLayerCloudwatchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sdkralxfrlgahlxt")
    public suspend
    fun cloudwatchConfiguration(argument: suspend JavaAppLayerCloudwatchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = JavaAppLayerCloudwatchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("pupwixtynvtwsiel")
    public suspend fun customConfigureRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("ohcsftcbqjmolpby")
    public suspend fun customConfigureRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("lgmnketdcmgtpaym")
    public suspend fun customDeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("gjwxcojxabifvaee")
    public suspend fun customDeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("hqhsykbvpglbwsvy")
    public suspend fun customInstanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customInstanceProfileArn = mapped
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("gxlupujbrhanfalf")
    public suspend fun customJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customJson = mapped
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("iaskohyhxruxkvdn")
    public suspend fun customSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("drommqkdcugxqgbv")
    public suspend fun customSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("cferlhuqsxdmxudv")
    public suspend fun customSetupRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("fbqkhospyjgnwplv")
    public suspend fun customSetupRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("xfbqbgybnyasbwku")
    public suspend fun customShutdownRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("sdxywcyscbxybbrm")
    public suspend fun customShutdownRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("fdkcbvrsjdikchhg")
    public suspend fun customUndeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("rxyojcdyoqrufhrq")
    public suspend fun customUndeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("ciygpmnljwattand")
    public suspend fun drainElbOnShutdown(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drainElbOnShutdown = mapped
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("udhibtxmmpybjlcs")
    public suspend fun ebsVolumes(`value`: List<JavaAppLayerEbsVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("tydcvgdmmkqafgus")
    public suspend
    fun ebsVolumes(argument: List<suspend JavaAppLayerEbsVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JavaAppLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("wixxmjfxetfnhiyn")
    public suspend fun ebsVolumes(
        vararg
        argument: suspend JavaAppLayerEbsVolumeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JavaAppLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("iwkpxdrmjqbafyjr")
    public suspend fun ebsVolumes(argument: suspend JavaAppLayerEbsVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JavaAppLayerEbsVolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("xjtfpybjedrowwjk")
    public suspend fun ebsVolumes(vararg values: JavaAppLayerEbsVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("rcikphyfctvnklxa")
    public suspend fun elasticLoadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticLoadBalancer = mapped
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("adydffdcviqnksnj")
    public suspend fun installUpdatesOnBoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installUpdatesOnBoot = mapped
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("suebnsvcuuehyisv")
    public suspend fun instanceShutdownTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceShutdownTimeout = mapped
    }

    /**
     * @param value Options to set for the JVM.
     */
    @JvmName("shyejlitvutstclc")
    public suspend fun jvmOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmOptions = mapped
    }

    /**
     * @param value Keyword for the type of JVM to use. Defaults to `openjdk`.
     */
    @JvmName("hpnlshqsbefawwbw")
    public suspend fun jvmType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmType = mapped
    }

    /**
     * @param value Version of JVM to use. Defaults to "7".
     */
    @JvmName("cfpkdxpuclitrwpm")
    public suspend fun jvmVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("ucdjjjlkjhyrkxcb")
    public suspend fun loadBasedAutoScaling(`value`: JavaAppLayerLoadBasedAutoScalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fhsedxuealxworqx")
    public suspend
    fun loadBasedAutoScaling(argument: suspend JavaAppLayerLoadBasedAutoScalingArgsBuilder.() -> Unit) {
        val toBeMapped = JavaAppLayerLoadBasedAutoScalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("sfnvvsebuaiyxbna")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("elyroafcywtmxjht")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("ttkhxyfoktbndjxw")
    public suspend fun systemPackages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("uofccdvfujklwjuh")
    public suspend fun systemPackages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("qpavymfismulfnud")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("qufvbtyinyrbiotu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("efgismdycivbifht")
    public suspend fun useEbsOptimizedInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEbsOptimizedInstances = mapped
    }

    internal fun build(): JavaAppLayerArgs = JavaAppLayerArgs(
        appServer = appServer,
        appServerVersion = appServerVersion,
        autoAssignElasticIps = autoAssignElasticIps,
        autoAssignPublicIps = autoAssignPublicIps,
        autoHealing = autoHealing,
        cloudwatchConfiguration = cloudwatchConfiguration,
        customConfigureRecipes = customConfigureRecipes,
        customDeployRecipes = customDeployRecipes,
        customInstanceProfileArn = customInstanceProfileArn,
        customJson = customJson,
        customSecurityGroupIds = customSecurityGroupIds,
        customSetupRecipes = customSetupRecipes,
        customShutdownRecipes = customShutdownRecipes,
        customUndeployRecipes = customUndeployRecipes,
        drainElbOnShutdown = drainElbOnShutdown,
        ebsVolumes = ebsVolumes,
        elasticLoadBalancer = elasticLoadBalancer,
        installUpdatesOnBoot = installUpdatesOnBoot,
        instanceShutdownTimeout = instanceShutdownTimeout,
        jvmOptions = jvmOptions,
        jvmType = jvmType,
        jvmVersion = jvmVersion,
        loadBasedAutoScaling = loadBasedAutoScaling,
        name = name,
        stackId = stackId,
        systemPackages = systemPackages,
        tags = tags,
        useEbsOptimizedInstances = useEbsOptimizedInstances,
    )
}
