@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.PermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks permission resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Permission;
 * import com.pulumi.aws.opsworks.PermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myStackPermission = new Permission("myStackPermission", PermissionArgs.builder()
 *             .allowSsh(true)
 *             .allowSudo(true)
 *             .level("iam_only")
 *             .userArn(aws_iam_user.user().arn())
 *             .stackId(aws_opsworks_stack.stack().id())
 *             .build());
 *     }
 * }
 * ```
 * @property allowSsh Whether the user is allowed to use SSH to communicate with the instance
 * @property allowSudo Whether the user is allowed to use sudo to elevate privileges
 * @property level The users permission level. Mus be one of `deny`, `show`, `deploy`, `manage`, `iam_only`
 * @property stackId The stack to set the permissions for
 * @property userArn The user's IAM ARN to set permissions for
 */
public data class PermissionArgs(
    public val allowSsh: Output<Boolean>? = null,
    public val allowSudo: Output<Boolean>? = null,
    public val level: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val userArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.PermissionArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.PermissionArgs =
        com.pulumi.aws.opsworks.PermissionArgs.builder()
            .allowSsh(allowSsh?.applyValue({ args0 -> args0 }))
            .allowSudo(allowSudo?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .userArn(userArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionArgs].
 */
@PulumiTagMarker
public class PermissionArgsBuilder internal constructor() {
    private var allowSsh: Output<Boolean>? = null

    private var allowSudo: Output<Boolean>? = null

    private var level: Output<String>? = null

    private var stackId: Output<String>? = null

    private var userArn: Output<String>? = null

    /**
     * @param value Whether the user is allowed to use SSH to communicate with the instance
     */
    @JvmName("oosigflaqdgginec")
    public suspend fun allowSsh(`value`: Output<Boolean>) {
        this.allowSsh = value
    }

    /**
     * @param value Whether the user is allowed to use sudo to elevate privileges
     */
    @JvmName("ocvkbkbdmebnnkji")
    public suspend fun allowSudo(`value`: Output<Boolean>) {
        this.allowSudo = value
    }

    /**
     * @param value The users permission level. Mus be one of `deny`, `show`, `deploy`, `manage`, `iam_only`
     */
    @JvmName("waqyhugemwulrjfd")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The stack to set the permissions for
     */
    @JvmName("tbjyaejviokyixnp")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value The user's IAM ARN to set permissions for
     */
    @JvmName("naudpoljqmckrqad")
    public suspend fun userArn(`value`: Output<String>) {
        this.userArn = value
    }

    /**
     * @param value Whether the user is allowed to use SSH to communicate with the instance
     */
    @JvmName("rrglejnmehpvhfyu")
    public suspend fun allowSsh(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSsh = mapped
    }

    /**
     * @param value Whether the user is allowed to use sudo to elevate privileges
     */
    @JvmName("ssuykwcwsmyhdjld")
    public suspend fun allowSudo(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSudo = mapped
    }

    /**
     * @param value The users permission level. Mus be one of `deny`, `show`, `deploy`, `manage`, `iam_only`
     */
    @JvmName("doishdaybloynijp")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The stack to set the permissions for
     */
    @JvmName("ajtbdxnmnrwaelmj")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value The user's IAM ARN to set permissions for
     */
    @JvmName("iarfioejqvuouofr")
    public suspend fun userArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userArn = mapped
    }

    internal fun build(): PermissionArgs = PermissionArgs(
        allowSsh = allowSsh,
        allowSudo = allowSudo,
        level = level,
        stackId = stackId,
        userArn = userArn,
    )
}
