@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.RailsAppLayerArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.RailsAppLayerCloudwatchConfigurationArgs
import com.pulumi.aws.opsworks.kotlin.inputs.RailsAppLayerCloudwatchConfigurationArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.RailsAppLayerEbsVolumeArgs
import com.pulumi.aws.opsworks.kotlin.inputs.RailsAppLayerEbsVolumeArgsBuilder
import com.pulumi.aws.opsworks.kotlin.inputs.RailsAppLayerLoadBasedAutoScalingArgs
import com.pulumi.aws.opsworks.kotlin.inputs.RailsAppLayerLoadBasedAutoScalingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks Ruby on Rails application layer resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.RailsAppLayer;
 * import com.pulumi.aws.opsworks.RailsAppLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new RailsAppLayer("app", RailsAppLayerArgs.builder()
 *             .stackId(aws_opsworks_stack.main().id())
 *             .build());
 *     }
 * }
 * ```
 * @property appServer Keyword for the app server to use. Defaults to "apache_passenger".
 * @property autoAssignElasticIps Whether to automatically assign an elastic IP address to the layer's instances.
 * @property autoAssignPublicIps For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
 * @property autoHealing Whether to enable auto-healing for the layer.
 * @property bundlerVersion When OpsWorks is managing Bundler, which version to use. Defaults to "1.5.3".
 * @property cloudwatchConfiguration
 * @property customConfigureRecipes
 * @property customDeployRecipes
 * @property customInstanceProfileArn The ARN of an IAM profile that will be used for the layer's instances.
 * @property customJson Custom JSON attributes to apply to the layer.
 * @property customSecurityGroupIds Ids for a set of security groups to apply to the layer's instances.
 * @property customSetupRecipes
 * @property customShutdownRecipes
 * @property customUndeployRecipes
 * @property drainElbOnShutdown Whether to enable Elastic Load Balancing connection draining.
 * @property ebsVolumes `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
 * @property elasticLoadBalancer Name of an Elastic Load Balancer to attach to this layer
 * @property installUpdatesOnBoot Whether to install OS and package updates on each instance when it boots.
 * @property instanceShutdownTimeout The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
 * @property loadBasedAutoScaling
 * @property manageBundler Whether OpsWorks should manage bundler. On by default.
 * @property name A human-readable name for the layer.
 * @property passengerVersion The version of Passenger to use. Defaults to "4.0.46".
 * @property rubyVersion The version of Ruby to use. Defaults to "2.0.0".
 * @property rubygemsVersion The version of RubyGems to use. Defaults to "2.2.2".
 * @property stackId ID of the stack the layer will belong to.
 * @property systemPackages Names of a set of system packages to install on the layer's instances.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The following extra optional arguments, all lists of Chef recipe names, allow
 * custom Chef recipes to be applied to layer instances at the five different
 * lifecycle events, if custom cookbooks are enabled on the layer's stack:
 * @property useEbsOptimizedInstances Whether to use EBS-optimized instances.
 */
public data class RailsAppLayerArgs(
    public val appServer: Output<String>? = null,
    public val autoAssignElasticIps: Output<Boolean>? = null,
    public val autoAssignPublicIps: Output<Boolean>? = null,
    public val autoHealing: Output<Boolean>? = null,
    public val bundlerVersion: Output<String>? = null,
    public val cloudwatchConfiguration: Output<RailsAppLayerCloudwatchConfigurationArgs>? = null,
    public val customConfigureRecipes: Output<List<String>>? = null,
    public val customDeployRecipes: Output<List<String>>? = null,
    public val customInstanceProfileArn: Output<String>? = null,
    public val customJson: Output<String>? = null,
    public val customSecurityGroupIds: Output<List<String>>? = null,
    public val customSetupRecipes: Output<List<String>>? = null,
    public val customShutdownRecipes: Output<List<String>>? = null,
    public val customUndeployRecipes: Output<List<String>>? = null,
    public val drainElbOnShutdown: Output<Boolean>? = null,
    public val ebsVolumes: Output<List<RailsAppLayerEbsVolumeArgs>>? = null,
    public val elasticLoadBalancer: Output<String>? = null,
    public val installUpdatesOnBoot: Output<Boolean>? = null,
    public val instanceShutdownTimeout: Output<Int>? = null,
    public val loadBasedAutoScaling: Output<RailsAppLayerLoadBasedAutoScalingArgs>? = null,
    public val manageBundler: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val passengerVersion: Output<String>? = null,
    public val rubyVersion: Output<String>? = null,
    public val rubygemsVersion: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val systemPackages: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useEbsOptimizedInstances: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.RailsAppLayerArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.RailsAppLayerArgs =
        com.pulumi.aws.opsworks.RailsAppLayerArgs.builder()
            .appServer(appServer?.applyValue({ args0 -> args0 }))
            .autoAssignElasticIps(autoAssignElasticIps?.applyValue({ args0 -> args0 }))
            .autoAssignPublicIps(autoAssignPublicIps?.applyValue({ args0 -> args0 }))
            .autoHealing(autoHealing?.applyValue({ args0 -> args0 }))
            .bundlerVersion(bundlerVersion?.applyValue({ args0 -> args0 }))
            .cloudwatchConfiguration(
                cloudwatchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customConfigureRecipes(
                customConfigureRecipes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customDeployRecipes(customDeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customInstanceProfileArn(customInstanceProfileArn?.applyValue({ args0 -> args0 }))
            .customJson(customJson?.applyValue({ args0 -> args0 }))
            .customSecurityGroupIds(
                customSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .customSetupRecipes(customSetupRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customShutdownRecipes(customShutdownRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customUndeployRecipes(customUndeployRecipes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .drainElbOnShutdown(drainElbOnShutdown?.applyValue({ args0 -> args0 }))
            .ebsVolumes(
                ebsVolumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .elasticLoadBalancer(elasticLoadBalancer?.applyValue({ args0 -> args0 }))
            .installUpdatesOnBoot(installUpdatesOnBoot?.applyValue({ args0 -> args0 }))
            .instanceShutdownTimeout(instanceShutdownTimeout?.applyValue({ args0 -> args0 }))
            .loadBasedAutoScaling(
                loadBasedAutoScaling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .manageBundler(manageBundler?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .passengerVersion(passengerVersion?.applyValue({ args0 -> args0 }))
            .rubyVersion(rubyVersion?.applyValue({ args0 -> args0 }))
            .rubygemsVersion(rubygemsVersion?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .systemPackages(systemPackages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useEbsOptimizedInstances(useEbsOptimizedInstances?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RailsAppLayerArgs].
 */
@PulumiTagMarker
public class RailsAppLayerArgsBuilder internal constructor() {
    private var appServer: Output<String>? = null

    private var autoAssignElasticIps: Output<Boolean>? = null

    private var autoAssignPublicIps: Output<Boolean>? = null

    private var autoHealing: Output<Boolean>? = null

    private var bundlerVersion: Output<String>? = null

    private var cloudwatchConfiguration: Output<RailsAppLayerCloudwatchConfigurationArgs>? = null

    private var customConfigureRecipes: Output<List<String>>? = null

    private var customDeployRecipes: Output<List<String>>? = null

    private var customInstanceProfileArn: Output<String>? = null

    private var customJson: Output<String>? = null

    private var customSecurityGroupIds: Output<List<String>>? = null

    private var customSetupRecipes: Output<List<String>>? = null

    private var customShutdownRecipes: Output<List<String>>? = null

    private var customUndeployRecipes: Output<List<String>>? = null

    private var drainElbOnShutdown: Output<Boolean>? = null

    private var ebsVolumes: Output<List<RailsAppLayerEbsVolumeArgs>>? = null

    private var elasticLoadBalancer: Output<String>? = null

    private var installUpdatesOnBoot: Output<Boolean>? = null

    private var instanceShutdownTimeout: Output<Int>? = null

    private var loadBasedAutoScaling: Output<RailsAppLayerLoadBasedAutoScalingArgs>? = null

    private var manageBundler: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var passengerVersion: Output<String>? = null

    private var rubyVersion: Output<String>? = null

    private var rubygemsVersion: Output<String>? = null

    private var stackId: Output<String>? = null

    private var systemPackages: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useEbsOptimizedInstances: Output<Boolean>? = null

    /**
     * @param value Keyword for the app server to use. Defaults to "apache_passenger".
     */
    @JvmName("mbtmplfmdwgcvsgy")
    public suspend fun appServer(`value`: Output<String>) {
        this.appServer = value
    }

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("lomjrdrxhapuogmj")
    public suspend fun autoAssignElasticIps(`value`: Output<Boolean>) {
        this.autoAssignElasticIps = value
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("bwiklbswmttwvggp")
    public suspend fun autoAssignPublicIps(`value`: Output<Boolean>) {
        this.autoAssignPublicIps = value
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("angxrhdpeqvpoecy")
    public suspend fun autoHealing(`value`: Output<Boolean>) {
        this.autoHealing = value
    }

    /**
     * @param value When OpsWorks is managing Bundler, which version to use. Defaults to "1.5.3".
     */
    @JvmName("jjvjgwjggwdquaac")
    public suspend fun bundlerVersion(`value`: Output<String>) {
        this.bundlerVersion = value
    }

    /**
     * @param value
     */
    @JvmName("srlxlieqkuqjhqwg")
    public suspend
    fun cloudwatchConfiguration(`value`: Output<RailsAppLayerCloudwatchConfigurationArgs>) {
        this.cloudwatchConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("ryhhanrcxivwfiwl")
    public suspend fun customConfigureRecipes(`value`: Output<List<String>>) {
        this.customConfigureRecipes = value
    }

    @JvmName("yvxgnsglefasynqx")
    public suspend fun customConfigureRecipes(vararg values: Output<String>) {
        this.customConfigureRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hlnkugkxdcotanjd")
    public suspend fun customConfigureRecipes(values: List<Output<String>>) {
        this.customConfigureRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cdgilqdkirpubhct")
    public suspend fun customDeployRecipes(`value`: Output<List<String>>) {
        this.customDeployRecipes = value
    }

    @JvmName("hjtjuanyndsgmmyi")
    public suspend fun customDeployRecipes(vararg values: Output<String>) {
        this.customDeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xnlykbknbadmlswk")
    public suspend fun customDeployRecipes(values: List<Output<String>>) {
        this.customDeployRecipes = Output.all(values)
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("jibjclwcxbijtfob")
    public suspend fun customInstanceProfileArn(`value`: Output<String>) {
        this.customInstanceProfileArn = value
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("picevqwacdxireos")
    public suspend fun customJson(`value`: Output<String>) {
        this.customJson = value
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("cdaaeirgqnfrvlac")
    public suspend fun customSecurityGroupIds(`value`: Output<List<String>>) {
        this.customSecurityGroupIds = value
    }

    @JvmName("fflpwwcppgwhgesc")
    public suspend fun customSecurityGroupIds(vararg values: Output<String>) {
        this.customSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("syvbnddnqreeggcd")
    public suspend fun customSecurityGroupIds(values: List<Output<String>>) {
        this.customSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gcncsqgeqqvbrrje")
    public suspend fun customSetupRecipes(`value`: Output<List<String>>) {
        this.customSetupRecipes = value
    }

    @JvmName("endtbfalvimauqab")
    public suspend fun customSetupRecipes(vararg values: Output<String>) {
        this.customSetupRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ncpwerhtbtldymbw")
    public suspend fun customSetupRecipes(values: List<Output<String>>) {
        this.customSetupRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mpywyylsmdhswlhe")
    public suspend fun customShutdownRecipes(`value`: Output<List<String>>) {
        this.customShutdownRecipes = value
    }

    @JvmName("idswfypjrrblfhap")
    public suspend fun customShutdownRecipes(vararg values: Output<String>) {
        this.customShutdownRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("owywctiokqgstkpg")
    public suspend fun customShutdownRecipes(values: List<Output<String>>) {
        this.customShutdownRecipes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("avaecelftovlqldm")
    public suspend fun customUndeployRecipes(`value`: Output<List<String>>) {
        this.customUndeployRecipes = value
    }

    @JvmName("rexrkbwpawbigdfd")
    public suspend fun customUndeployRecipes(vararg values: Output<String>) {
        this.customUndeployRecipes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("biiklexslejkiqdk")
    public suspend fun customUndeployRecipes(values: List<Output<String>>) {
        this.customUndeployRecipes = Output.all(values)
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("hfyqoxwgjljwtexn")
    public suspend fun drainElbOnShutdown(`value`: Output<Boolean>) {
        this.drainElbOnShutdown = value
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("jowsojbxtecgkffb")
    public suspend fun ebsVolumes(`value`: Output<List<RailsAppLayerEbsVolumeArgs>>) {
        this.ebsVolumes = value
    }

    @JvmName("tfqoqlldgvsofenq")
    public suspend fun ebsVolumes(vararg values: Output<RailsAppLayerEbsVolumeArgs>) {
        this.ebsVolumes = Output.all(values.asList())
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("broulduhxxpwuyuv")
    public suspend fun ebsVolumes(values: List<Output<RailsAppLayerEbsVolumeArgs>>) {
        this.ebsVolumes = Output.all(values)
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("lynpxafmdbwxdekx")
    public suspend fun elasticLoadBalancer(`value`: Output<String>) {
        this.elasticLoadBalancer = value
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("qepwgtapgmmhiurk")
    public suspend fun installUpdatesOnBoot(`value`: Output<Boolean>) {
        this.installUpdatesOnBoot = value
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("dyanqqbqgotyrfgj")
    public suspend fun instanceShutdownTimeout(`value`: Output<Int>) {
        this.instanceShutdownTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("iiflwxnxoujlokxu")
    public suspend fun loadBasedAutoScaling(`value`: Output<RailsAppLayerLoadBasedAutoScalingArgs>) {
        this.loadBasedAutoScaling = value
    }

    /**
     * @param value Whether OpsWorks should manage bundler. On by default.
     */
    @JvmName("xveiwygbxyrcujmq")
    public suspend fun manageBundler(`value`: Output<Boolean>) {
        this.manageBundler = value
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("uxjmyhxptmpymvkp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of Passenger to use. Defaults to "4.0.46".
     */
    @JvmName("tmpgetguqrgnipfs")
    public suspend fun passengerVersion(`value`: Output<String>) {
        this.passengerVersion = value
    }

    /**
     * @param value The version of Ruby to use. Defaults to "2.0.0".
     */
    @JvmName("bqfjegduusflbxlk")
    public suspend fun rubyVersion(`value`: Output<String>) {
        this.rubyVersion = value
    }

    /**
     * @param value The version of RubyGems to use. Defaults to "2.2.2".
     */
    @JvmName("pblokbgqqurfottm")
    public suspend fun rubygemsVersion(`value`: Output<String>) {
        this.rubygemsVersion = value
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("nqnmeodombxruqig")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("jgxjqwwmpbrukxrj")
    public suspend fun systemPackages(`value`: Output<List<String>>) {
        this.systemPackages = value
    }

    @JvmName("saaqqnnkuvripaba")
    public suspend fun systemPackages(vararg values: Output<String>) {
        this.systemPackages = Output.all(values.asList())
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("eohljuatlwijyxuj")
    public suspend fun systemPackages(values: List<Output<String>>) {
        this.systemPackages = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("pdsxhjmurjkaceic")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("kqysfbilubcijncs")
    public suspend fun useEbsOptimizedInstances(`value`: Output<Boolean>) {
        this.useEbsOptimizedInstances = value
    }

    /**
     * @param value Keyword for the app server to use. Defaults to "apache_passenger".
     */
    @JvmName("rxrvapdgmlufinaf")
    public suspend fun appServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appServer = mapped
    }

    /**
     * @param value Whether to automatically assign an elastic IP address to the layer's instances.
     */
    @JvmName("jhnkvwxrbscimmbh")
    public suspend fun autoAssignElasticIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignElasticIps = mapped
    }

    /**
     * @param value For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    @JvmName("jxdlticuiwjxqnps")
    public suspend fun autoAssignPublicIps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssignPublicIps = mapped
    }

    /**
     * @param value Whether to enable auto-healing for the layer.
     */
    @JvmName("wqcaraubeqvqrmpm")
    public suspend fun autoHealing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealing = mapped
    }

    /**
     * @param value When OpsWorks is managing Bundler, which version to use. Defaults to "1.5.3".
     */
    @JvmName("spjrqjfquuhxbswo")
    public suspend fun bundlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundlerVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("isgopqmuqdfxiito")
    public suspend fun cloudwatchConfiguration(`value`: RailsAppLayerCloudwatchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yehqkigkrvagkgow")
    public suspend
    fun cloudwatchConfiguration(argument: suspend RailsAppLayerCloudwatchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RailsAppLayerCloudwatchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("gnkwvttbercyxcfn")
    public suspend fun customConfigureRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("gxfkjtjnkjbkxbue")
    public suspend fun customConfigureRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customConfigureRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("gakagaakkllhvgqe")
    public suspend fun customDeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("gayvtunancxuugkg")
    public suspend fun customDeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDeployRecipes = mapped
    }

    /**
     * @param value The ARN of an IAM profile that will be used for the layer's instances.
     */
    @JvmName("bjopehnjcdrbuoww")
    public suspend fun customInstanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customInstanceProfileArn = mapped
    }

    /**
     * @param value Custom JSON attributes to apply to the layer.
     */
    @JvmName("metcawqyujokugko")
    public suspend fun customJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customJson = mapped
    }

    /**
     * @param value Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("xtvvobjcvmpcpmyc")
    public suspend fun customSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param values Ids for a set of security groups to apply to the layer's instances.
     */
    @JvmName("bnifrjqclsojbliy")
    public suspend fun customSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSecurityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("wghucfvjhmklkdxv")
    public suspend fun customSetupRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("apofjkhwnkpcjfgk")
    public suspend fun customSetupRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customSetupRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("oxlsfgktdarcosuq")
    public suspend fun customShutdownRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("nllhejuirhgjgqay")
    public suspend fun customShutdownRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customShutdownRecipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("bwawoongbsoslnic")
    public suspend fun customUndeployRecipes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param values
     */
    @JvmName("hkovoctblfhqaffw")
    public suspend fun customUndeployRecipes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customUndeployRecipes = mapped
    }

    /**
     * @param value Whether to enable Elastic Load Balancing connection draining.
     */
    @JvmName("pswxvpxrodrniffw")
    public suspend fun drainElbOnShutdown(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drainElbOnShutdown = mapped
    }

    /**
     * @param value `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("guxwilggoqgftmdx")
    public suspend fun ebsVolumes(`value`: List<RailsAppLayerEbsVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("kecspvagbtyuybik")
    public suspend
    fun ebsVolumes(argument: List<suspend RailsAppLayerEbsVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RailsAppLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("ccvuwmvemruvmhct")
    public suspend fun ebsVolumes(
        vararg
        argument: suspend RailsAppLayerEbsVolumeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RailsAppLayerEbsVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param argument `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("lixgbfisqgytckxr")
    public suspend fun ebsVolumes(argument: suspend RailsAppLayerEbsVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RailsAppLayerEbsVolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    /**
     * @param values `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    @JvmName("pysamckcojdjccov")
    public suspend fun ebsVolumes(vararg values: RailsAppLayerEbsVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param value Name of an Elastic Load Balancer to attach to this layer
     */
    @JvmName("xhfpdiistwsocemp")
    public suspend fun elasticLoadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticLoadBalancer = mapped
    }

    /**
     * @param value Whether to install OS and package updates on each instance when it boots.
     */
    @JvmName("wkkltxaaiclhbypq")
    public suspend fun installUpdatesOnBoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installUpdatesOnBoot = mapped
    }

    /**
     * @param value The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    @JvmName("btcsfdsgbrntftvn")
    public suspend fun instanceShutdownTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceShutdownTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("aqexpykmnifgqqnf")
    public suspend fun loadBasedAutoScaling(`value`: RailsAppLayerLoadBasedAutoScalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eihafdkipxlljlfc")
    public suspend
    fun loadBasedAutoScaling(argument: suspend RailsAppLayerLoadBasedAutoScalingArgsBuilder.() -> Unit) {
        val toBeMapped = RailsAppLayerLoadBasedAutoScalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loadBasedAutoScaling = mapped
    }

    /**
     * @param value Whether OpsWorks should manage bundler. On by default.
     */
    @JvmName("ypygmlgqtgunbepp")
    public suspend fun manageBundler(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manageBundler = mapped
    }

    /**
     * @param value A human-readable name for the layer.
     */
    @JvmName("qebxkpjwpahngmnw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of Passenger to use. Defaults to "4.0.46".
     */
    @JvmName("fejsrkrlbfvvtisp")
    public suspend fun passengerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passengerVersion = mapped
    }

    /**
     * @param value The version of Ruby to use. Defaults to "2.0.0".
     */
    @JvmName("ocdxicbpplqruyba")
    public suspend fun rubyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rubyVersion = mapped
    }

    /**
     * @param value The version of RubyGems to use. Defaults to "2.2.2".
     */
    @JvmName("bkprngigvcrqccpu")
    public suspend fun rubygemsVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rubygemsVersion = mapped
    }

    /**
     * @param value ID of the stack the layer will belong to.
     */
    @JvmName("ypyvmywdnqvolvee")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("lcvdembxpuxtrcfr")
    public suspend fun systemPackages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param values Names of a set of system packages to install on the layer's instances.
     */
    @JvmName("ybymotrcpaolfbpu")
    public suspend fun systemPackages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemPackages = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("hdmudaocvsonqaqg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    @JvmName("vaqlrkjjtooxmlnb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether to use EBS-optimized instances.
     */
    @JvmName("uvpptkcqvtvkclde")
    public suspend fun useEbsOptimizedInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEbsOptimizedInstances = mapped
    }

    internal fun build(): RailsAppLayerArgs = RailsAppLayerArgs(
        appServer = appServer,
        autoAssignElasticIps = autoAssignElasticIps,
        autoAssignPublicIps = autoAssignPublicIps,
        autoHealing = autoHealing,
        bundlerVersion = bundlerVersion,
        cloudwatchConfiguration = cloudwatchConfiguration,
        customConfigureRecipes = customConfigureRecipes,
        customDeployRecipes = customDeployRecipes,
        customInstanceProfileArn = customInstanceProfileArn,
        customJson = customJson,
        customSecurityGroupIds = customSecurityGroupIds,
        customSetupRecipes = customSetupRecipes,
        customShutdownRecipes = customShutdownRecipes,
        customUndeployRecipes = customUndeployRecipes,
        drainElbOnShutdown = drainElbOnShutdown,
        ebsVolumes = ebsVolumes,
        elasticLoadBalancer = elasticLoadBalancer,
        installUpdatesOnBoot = installUpdatesOnBoot,
        instanceShutdownTimeout = instanceShutdownTimeout,
        loadBasedAutoScaling = loadBasedAutoScaling,
        manageBundler = manageBundler,
        name = name,
        passengerVersion = passengerVersion,
        rubyVersion = rubyVersion,
        rubygemsVersion = rubygemsVersion,
        stackId = stackId,
        systemPackages = systemPackages,
        tags = tags,
        useEbsOptimizedInstances = useEbsOptimizedInstances,
    )
}
