@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.RdsDbInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks RDS DB Instance resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.RdsDbInstance;
 * import com.pulumi.aws.opsworks.RdsDbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myInstance = new RdsDbInstance("myInstance", RdsDbInstanceArgs.builder()
 *             .stackId(aws_opsworks_stack.my_stack().id())
 *             .rdsDbInstanceArn(aws_db_instance.my_instance().arn())
 *             .dbUser("someUser")
 *             .dbPassword("somePass")
 *             .build());
 *     }
 * }
 * ```
 * @property dbPassword A db password
 * @property dbUser A db username
 * @property rdsDbInstanceArn The db instance to register for this stack. Changing this will force a new resource.
 * @property stackId The stack to register a db instance for. Changing this will force a new resource.
 */
public data class RdsDbInstanceArgs(
    public val dbPassword: Output<String>? = null,
    public val dbUser: Output<String>? = null,
    public val rdsDbInstanceArn: Output<String>? = null,
    public val stackId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.RdsDbInstanceArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.RdsDbInstanceArgs =
        com.pulumi.aws.opsworks.RdsDbInstanceArgs.builder()
            .dbPassword(dbPassword?.applyValue({ args0 -> args0 }))
            .dbUser(dbUser?.applyValue({ args0 -> args0 }))
            .rdsDbInstanceArn(rdsDbInstanceArn?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RdsDbInstanceArgs].
 */
@PulumiTagMarker
public class RdsDbInstanceArgsBuilder internal constructor() {
    private var dbPassword: Output<String>? = null

    private var dbUser: Output<String>? = null

    private var rdsDbInstanceArn: Output<String>? = null

    private var stackId: Output<String>? = null

    /**
     * @param value A db password
     */
    @JvmName("gviwrsgpqshjqsal")
    public suspend fun dbPassword(`value`: Output<String>) {
        this.dbPassword = value
    }

    /**
     * @param value A db username
     */
    @JvmName("gshnvregnirscpls")
    public suspend fun dbUser(`value`: Output<String>) {
        this.dbUser = value
    }

    /**
     * @param value The db instance to register for this stack. Changing this will force a new resource.
     */
    @JvmName("ltwyabkrwpifhhgb")
    public suspend fun rdsDbInstanceArn(`value`: Output<String>) {
        this.rdsDbInstanceArn = value
    }

    /**
     * @param value The stack to register a db instance for. Changing this will force a new resource.
     */
    @JvmName("swqwvlhocoskgtaf")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value A db password
     */
    @JvmName("angxtbmhnixpgbus")
    public suspend fun dbPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPassword = mapped
    }

    /**
     * @param value A db username
     */
    @JvmName("jkpawojojptglrfj")
    public suspend fun dbUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUser = mapped
    }

    /**
     * @param value The db instance to register for this stack. Changing this will force a new resource.
     */
    @JvmName("fmnktnwlqmxvreag")
    public suspend fun rdsDbInstanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdsDbInstanceArn = mapped
    }

    /**
     * @param value The stack to register a db instance for. Changing this will force a new resource.
     */
    @JvmName("leskaarybetddcke")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    internal fun build(): RdsDbInstanceArgs = RdsDbInstanceArgs(
        dbPassword = dbPassword,
        dbUser = dbUser,
        rdsDbInstanceArn = rdsDbInstanceArn,
        stackId = stackId,
    )
}
