@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.StackArgs.builder
import com.pulumi.aws.opsworks.kotlin.inputs.StackCustomCookbooksSourceArgs
import com.pulumi.aws.opsworks.kotlin.inputs.StackCustomCookbooksSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks stack resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Stack;
 * import com.pulumi.aws.opsworks.StackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Stack("main", StackArgs.builder()
 *             .region("us-west-1")
 *             .serviceRoleArn(aws_iam_role.opsworks().arn())
 *             .defaultInstanceProfileArn(aws_iam_instance_profile.opsworks().arn())
 *             .tags(Map.of("Name", "foobar-stack"))
 *             .customJson("""
 * {
 *  "foobar": {
 *     "version": "1.0.0"
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpsWorks stacks using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:opsworks/stack:Stack bar 00000000-0000-0000-0000-000000000000
 * ```
 * @property agentVersion If set to `"LATEST"`, OpsWorks will automatically install the latest version.
 * @property berkshelfVersion If `manage_berkshelf` is enabled, the version of Berkshelf to use.
 * @property color Color to paint next to the stack's resources in the OpsWorks console.
 * @property configurationManagerName Name of the configuration manager to use. Defaults to "Chef".
 * @property configurationManagerVersion Version of the configuration manager to use. Defaults to "11.4".
 * @property customCookbooksSources When `use_custom_cookbooks` is set, provide this sub-object as described below.
 * @property customJson Custom JSON attributes to apply to the entire stack.
 * @property defaultAvailabilityZone Name of the availability zone where instances will be created by default.
 * Cannot be set when `vpc_id` is set.
 * @property defaultInstanceProfileArn The ARN of an IAM Instance Profile that created instances will have by default.
 * @property defaultOs Name of OS that will be installed on instances by default.
 * @property defaultRootDeviceType Name of the type of root device instances will have by default.
 * @property defaultSshKeyName Name of the SSH keypair that instances will have by default.
 * @property defaultSubnetId ID of the subnet in which instances will be created by default.
 * Required if `vpc_id` is set to a VPC other than the default VPC, and forbidden if it isn't.
 * @property hostnameTheme Keyword representing the naming scheme that will be used for instance hostnames within this stack.
 * @property manageBerkshelf Boolean value controlling whether Opsworks will run Berkshelf for this stack.
 * @property name The name of the stack.
 * @property region The name of the region where the stack will exist.
 * @property serviceRoleArn The ARN of an IAM role that the OpsWorks service will act as.
 * @property tags A map of tags to assign to the resource.
 * If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property useCustomCookbooks Boolean value controlling whether the custom cookbook settings are enabled.
 * @property useOpsworksSecurityGroups Boolean value controlling whether the standard OpsWorks security groups apply to created instances.
 * @property vpcId ID of the VPC that this stack belongs to.
 * Defaults to the region's default VPC.
 */
public data class StackArgs(
    public val agentVersion: Output<String>? = null,
    public val berkshelfVersion: Output<String>? = null,
    public val color: Output<String>? = null,
    public val configurationManagerName: Output<String>? = null,
    public val configurationManagerVersion: Output<String>? = null,
    public val customCookbooksSources: Output<List<StackCustomCookbooksSourceArgs>>? = null,
    public val customJson: Output<String>? = null,
    public val defaultAvailabilityZone: Output<String>? = null,
    public val defaultInstanceProfileArn: Output<String>? = null,
    public val defaultOs: Output<String>? = null,
    public val defaultRootDeviceType: Output<String>? = null,
    public val defaultSshKeyName: Output<String>? = null,
    public val defaultSubnetId: Output<String>? = null,
    public val hostnameTheme: Output<String>? = null,
    public val manageBerkshelf: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val region: Output<String>? = null,
    public val serviceRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useCustomCookbooks: Output<Boolean>? = null,
    public val useOpsworksSecurityGroups: Output<Boolean>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.StackArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.StackArgs =
        com.pulumi.aws.opsworks.StackArgs.builder()
            .agentVersion(agentVersion?.applyValue({ args0 -> args0 }))
            .berkshelfVersion(berkshelfVersion?.applyValue({ args0 -> args0 }))
            .color(color?.applyValue({ args0 -> args0 }))
            .configurationManagerName(configurationManagerName?.applyValue({ args0 -> args0 }))
            .configurationManagerVersion(configurationManagerVersion?.applyValue({ args0 -> args0 }))
            .customCookbooksSources(
                customCookbooksSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .customJson(customJson?.applyValue({ args0 -> args0 }))
            .defaultAvailabilityZone(defaultAvailabilityZone?.applyValue({ args0 -> args0 }))
            .defaultInstanceProfileArn(defaultInstanceProfileArn?.applyValue({ args0 -> args0 }))
            .defaultOs(defaultOs?.applyValue({ args0 -> args0 }))
            .defaultRootDeviceType(defaultRootDeviceType?.applyValue({ args0 -> args0 }))
            .defaultSshKeyName(defaultSshKeyName?.applyValue({ args0 -> args0 }))
            .defaultSubnetId(defaultSubnetId?.applyValue({ args0 -> args0 }))
            .hostnameTheme(hostnameTheme?.applyValue({ args0 -> args0 }))
            .manageBerkshelf(manageBerkshelf?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useCustomCookbooks(useCustomCookbooks?.applyValue({ args0 -> args0 }))
            .useOpsworksSecurityGroups(useOpsworksSecurityGroups?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackArgs].
 */
@PulumiTagMarker
public class StackArgsBuilder internal constructor() {
    private var agentVersion: Output<String>? = null

    private var berkshelfVersion: Output<String>? = null

    private var color: Output<String>? = null

    private var configurationManagerName: Output<String>? = null

    private var configurationManagerVersion: Output<String>? = null

    private var customCookbooksSources: Output<List<StackCustomCookbooksSourceArgs>>? = null

    private var customJson: Output<String>? = null

    private var defaultAvailabilityZone: Output<String>? = null

    private var defaultInstanceProfileArn: Output<String>? = null

    private var defaultOs: Output<String>? = null

    private var defaultRootDeviceType: Output<String>? = null

    private var defaultSshKeyName: Output<String>? = null

    private var defaultSubnetId: Output<String>? = null

    private var hostnameTheme: Output<String>? = null

    private var manageBerkshelf: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var region: Output<String>? = null

    private var serviceRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useCustomCookbooks: Output<Boolean>? = null

    private var useOpsworksSecurityGroups: Output<Boolean>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value If set to `"LATEST"`, OpsWorks will automatically install the latest version.
     */
    @JvmName("qscnbsjkyppvhwmi")
    public suspend fun agentVersion(`value`: Output<String>) {
        this.agentVersion = value
    }

    /**
     * @param value If `manage_berkshelf` is enabled, the version of Berkshelf to use.
     */
    @JvmName("elwuiqsetndibxsj")
    public suspend fun berkshelfVersion(`value`: Output<String>) {
        this.berkshelfVersion = value
    }

    /**
     * @param value Color to paint next to the stack's resources in the OpsWorks console.
     */
    @JvmName("gxmlhtxrlfbxdmke")
    public suspend fun color(`value`: Output<String>) {
        this.color = value
    }

    /**
     * @param value Name of the configuration manager to use. Defaults to "Chef".
     */
    @JvmName("junuyethnbcjbuyw")
    public suspend fun configurationManagerName(`value`: Output<String>) {
        this.configurationManagerName = value
    }

    /**
     * @param value Version of the configuration manager to use. Defaults to "11.4".
     */
    @JvmName("hyrqjylufbnxgyjv")
    public suspend fun configurationManagerVersion(`value`: Output<String>) {
        this.configurationManagerVersion = value
    }

    /**
     * @param value When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    @JvmName("pxdqlifcpyhwdbvo")
    public suspend fun customCookbooksSources(`value`: Output<List<StackCustomCookbooksSourceArgs>>) {
        this.customCookbooksSources = value
    }

    @JvmName("crcwaqcnyohibela")
    public suspend fun customCookbooksSources(vararg values: Output<StackCustomCookbooksSourceArgs>) {
        this.customCookbooksSources = Output.all(values.asList())
    }

    /**
     * @param values When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    @JvmName("dasfukcitolcpbfg")
    public suspend fun customCookbooksSources(values: List<Output<StackCustomCookbooksSourceArgs>>) {
        this.customCookbooksSources = Output.all(values)
    }

    /**
     * @param value Custom JSON attributes to apply to the entire stack.
     */
    @JvmName("wwydsoodbupbtcit")
    public suspend fun customJson(`value`: Output<String>) {
        this.customJson = value
    }

    /**
     * @param value Name of the availability zone where instances will be created by default.
     * Cannot be set when `vpc_id` is set.
     */
    @JvmName("qblvnxbdgmovsxpg")
    public suspend fun defaultAvailabilityZone(`value`: Output<String>) {
        this.defaultAvailabilityZone = value
    }

    /**
     * @param value The ARN of an IAM Instance Profile that created instances will have by default.
     */
    @JvmName("xixvboydlamktjyd")
    public suspend fun defaultInstanceProfileArn(`value`: Output<String>) {
        this.defaultInstanceProfileArn = value
    }

    /**
     * @param value Name of OS that will be installed on instances by default.
     */
    @JvmName("vhoofpkmdqnxiijf")
    public suspend fun defaultOs(`value`: Output<String>) {
        this.defaultOs = value
    }

    /**
     * @param value Name of the type of root device instances will have by default.
     */
    @JvmName("chkstpygoaulxnxi")
    public suspend fun defaultRootDeviceType(`value`: Output<String>) {
        this.defaultRootDeviceType = value
    }

    /**
     * @param value Name of the SSH keypair that instances will have by default.
     */
    @JvmName("xkfsoqxmmfwflxtr")
    public suspend fun defaultSshKeyName(`value`: Output<String>) {
        this.defaultSshKeyName = value
    }

    /**
     * @param value ID of the subnet in which instances will be created by default.
     * Required if `vpc_id` is set to a VPC other than the default VPC, and forbidden if it isn't.
     */
    @JvmName("vyoajbkwbvadxket")
    public suspend fun defaultSubnetId(`value`: Output<String>) {
        this.defaultSubnetId = value
    }

    /**
     * @param value Keyword representing the naming scheme that will be used for instance hostnames within this stack.
     */
    @JvmName("twuoshcrcnfpvyvi")
    public suspend fun hostnameTheme(`value`: Output<String>) {
        this.hostnameTheme = value
    }

    /**
     * @param value Boolean value controlling whether Opsworks will run Berkshelf for this stack.
     */
    @JvmName("eqxxcujsxdajnrwu")
    public suspend fun manageBerkshelf(`value`: Output<Boolean>) {
        this.manageBerkshelf = value
    }

    /**
     * @param value The name of the stack.
     */
    @JvmName("rsvoqvlmamekcmrs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the region where the stack will exist.
     */
    @JvmName("adbqfqugqgmggilv")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The ARN of an IAM role that the OpsWorks service will act as.
     */
    @JvmName("hxcdgfimtwchbvfm")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource.
     * If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tjlxmsnwphoijegs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Boolean value controlling whether the custom cookbook settings are enabled.
     */
    @JvmName("upaayxawqjvcisjt")
    public suspend fun useCustomCookbooks(`value`: Output<Boolean>) {
        this.useCustomCookbooks = value
    }

    /**
     * @param value Boolean value controlling whether the standard OpsWorks security groups apply to created instances.
     */
    @JvmName("ghcbetrgdujmxdfx")
    public suspend fun useOpsworksSecurityGroups(`value`: Output<Boolean>) {
        this.useOpsworksSecurityGroups = value
    }

    /**
     * @param value ID of the VPC that this stack belongs to.
     * Defaults to the region's default VPC.
     */
    @JvmName("xwtlfxqjmgssxfyb")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value If set to `"LATEST"`, OpsWorks will automatically install the latest version.
     */
    @JvmName("cvvfnqoybbximyll")
    public suspend fun agentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVersion = mapped
    }

    /**
     * @param value If `manage_berkshelf` is enabled, the version of Berkshelf to use.
     */
    @JvmName("apatbmbnxshgtdaa")
    public suspend fun berkshelfVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.berkshelfVersion = mapped
    }

    /**
     * @param value Color to paint next to the stack's resources in the OpsWorks console.
     */
    @JvmName("kaobhvgokoofoemw")
    public suspend fun color(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.color = mapped
    }

    /**
     * @param value Name of the configuration manager to use. Defaults to "Chef".
     */
    @JvmName("ogekjxcoepwgmdsi")
    public suspend fun configurationManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationManagerName = mapped
    }

    /**
     * @param value Version of the configuration manager to use. Defaults to "11.4".
     */
    @JvmName("komawblpyctfldgw")
    public suspend fun configurationManagerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationManagerVersion = mapped
    }

    /**
     * @param value When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    @JvmName("ahvcxnbmlakwxaiv")
    public suspend fun customCookbooksSources(`value`: List<StackCustomCookbooksSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customCookbooksSources = mapped
    }

    /**
     * @param argument When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    @JvmName("bevkqnamjfponide")
    public suspend
    fun customCookbooksSources(argument: List<suspend StackCustomCookbooksSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackCustomCookbooksSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customCookbooksSources = mapped
    }

    /**
     * @param argument When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    @JvmName("jbjavsdeksciyivm")
    public suspend fun customCookbooksSources(
        vararg
        argument: suspend StackCustomCookbooksSourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StackCustomCookbooksSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customCookbooksSources = mapped
    }

    /**
     * @param argument When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    @JvmName("kgwrupynypmnixal")
    public suspend
    fun customCookbooksSources(argument: suspend StackCustomCookbooksSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StackCustomCookbooksSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customCookbooksSources = mapped
    }

    /**
     * @param values When `use_custom_cookbooks` is set, provide this sub-object as described below.
     */
    @JvmName("xvvxkraiknhltvqa")
    public suspend fun customCookbooksSources(vararg values: StackCustomCookbooksSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customCookbooksSources = mapped
    }

    /**
     * @param value Custom JSON attributes to apply to the entire stack.
     */
    @JvmName("rrnoypjpbbirfnvk")
    public suspend fun customJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customJson = mapped
    }

    /**
     * @param value Name of the availability zone where instances will be created by default.
     * Cannot be set when `vpc_id` is set.
     */
    @JvmName("kfqmrkujrylbodqc")
    public suspend fun defaultAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAvailabilityZone = mapped
    }

    /**
     * @param value The ARN of an IAM Instance Profile that created instances will have by default.
     */
    @JvmName("unvojudcqytshavx")
    public suspend fun defaultInstanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultInstanceProfileArn = mapped
    }

    /**
     * @param value Name of OS that will be installed on instances by default.
     */
    @JvmName("ktstrktmcfdopyec")
    public suspend fun defaultOs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultOs = mapped
    }

    /**
     * @param value Name of the type of root device instances will have by default.
     */
    @JvmName("seyqwifbliksfptl")
    public suspend fun defaultRootDeviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRootDeviceType = mapped
    }

    /**
     * @param value Name of the SSH keypair that instances will have by default.
     */
    @JvmName("duwtwnoalfknknix")
    public suspend fun defaultSshKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSshKeyName = mapped
    }

    /**
     * @param value ID of the subnet in which instances will be created by default.
     * Required if `vpc_id` is set to a VPC other than the default VPC, and forbidden if it isn't.
     */
    @JvmName("vuwxelsphksipgan")
    public suspend fun defaultSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSubnetId = mapped
    }

    /**
     * @param value Keyword representing the naming scheme that will be used for instance hostnames within this stack.
     */
    @JvmName("emlqjqtuuguamydc")
    public suspend fun hostnameTheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostnameTheme = mapped
    }

    /**
     * @param value Boolean value controlling whether Opsworks will run Berkshelf for this stack.
     */
    @JvmName("riehidiykdxkprsg")
    public suspend fun manageBerkshelf(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manageBerkshelf = mapped
    }

    /**
     * @param value The name of the stack.
     */
    @JvmName("glsbwaoavkqnwrwr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the region where the stack will exist.
     */
    @JvmName("myvoxjajjtbudmab")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The ARN of an IAM role that the OpsWorks service will act as.
     */
    @JvmName("lmtimrejbipplqky")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource.
     * If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pshpfxjnykdnqycc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource.
     * If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("grapgwqrnlivhddy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Boolean value controlling whether the custom cookbook settings are enabled.
     */
    @JvmName("kecvmsaqpgtwmgyp")
    public suspend fun useCustomCookbooks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCustomCookbooks = mapped
    }

    /**
     * @param value Boolean value controlling whether the standard OpsWorks security groups apply to created instances.
     */
    @JvmName("ukcdqxftbkjohipa")
    public suspend fun useOpsworksSecurityGroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useOpsworksSecurityGroups = mapped
    }

    /**
     * @param value ID of the VPC that this stack belongs to.
     * Defaults to the region's default VPC.
     */
    @JvmName("bxccyifrywebowlw")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): StackArgs = StackArgs(
        agentVersion = agentVersion,
        berkshelfVersion = berkshelfVersion,
        color = color,
        configurationManagerName = configurationManagerName,
        configurationManagerVersion = configurationManagerVersion,
        customCookbooksSources = customCookbooksSources,
        customJson = customJson,
        defaultAvailabilityZone = defaultAvailabilityZone,
        defaultInstanceProfileArn = defaultInstanceProfileArn,
        defaultOs = defaultOs,
        defaultRootDeviceType = defaultRootDeviceType,
        defaultSshKeyName = defaultSshKeyName,
        defaultSubnetId = defaultSubnetId,
        hostnameTheme = hostnameTheme,
        manageBerkshelf = manageBerkshelf,
        name = name,
        region = region,
        serviceRoleArn = serviceRoleArn,
        tags = tags,
        useCustomCookbooks = useCustomCookbooks,
        useOpsworksSecurityGroups = useOpsworksSecurityGroups,
        vpcId = vpcId,
    )
}
