@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.kotlin.outputs.StaticWebLayerCloudwatchConfiguration
import com.pulumi.aws.opsworks.kotlin.outputs.StaticWebLayerEbsVolume
import com.pulumi.aws.opsworks.kotlin.outputs.StaticWebLayerLoadBasedAutoScaling
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.opsworks.kotlin.outputs.StaticWebLayerCloudwatchConfiguration.Companion.toKotlin as staticWebLayerCloudwatchConfigurationToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.StaticWebLayerEbsVolume.Companion.toKotlin as staticWebLayerEbsVolumeToKotlin
import com.pulumi.aws.opsworks.kotlin.outputs.StaticWebLayerLoadBasedAutoScaling.Companion.toKotlin as staticWebLayerLoadBasedAutoScalingToKotlin

/**
 * Builder for [StaticWebLayer].
 */
@PulumiTagMarker
public class StaticWebLayerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticWebLayerArgs = StaticWebLayerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticWebLayerArgsBuilder.() -> Unit) {
        val builder = StaticWebLayerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StaticWebLayer {
        val builtJavaResource = com.pulumi.aws.opsworks.StaticWebLayer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StaticWebLayer(builtJavaResource)
    }
}

/**
 * Provides an OpsWorks static web server layer resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.StaticWebLayer;
 * import com.pulumi.aws.opsworks.StaticWebLayerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new StaticWebLayer("web", StaticWebLayerArgs.builder()
 *             .stackId(aws_opsworks_stack.main().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import OpsWorks static web server Layers using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:opsworks/staticWebLayer:StaticWebLayer bar 00000000-0000-0000-0000-000000000000
 * ```
 *
 */
public class StaticWebLayer internal constructor(
    override val javaResource: com.pulumi.aws.opsworks.StaticWebLayer,
) : KotlinCustomResource(javaResource, StaticWebLayerMapper) {
    /**
     * The Amazon Resource Name(ARN) of the layer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically assign an elastic IP address to the layer's instances.
     */
    public val autoAssignElasticIps: Output<Boolean>?
        get() = javaResource.autoAssignElasticIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
     */
    public val autoAssignPublicIps: Output<Boolean>?
        get() = javaResource.autoAssignPublicIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable auto-healing for the layer.
     */
    public val autoHealing: Output<Boolean>?
        get() = javaResource.autoHealing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val cloudwatchConfiguration: Output<StaticWebLayerCloudwatchConfiguration>?
        get() = javaResource.cloudwatchConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> staticWebLayerCloudwatchConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    public val customConfigureRecipes: Output<List<String>>?
        get() = javaResource.customConfigureRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customDeployRecipes: Output<List<String>>?
        get() = javaResource.customDeployRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The ARN of an IAM profile that will be used for the layer's instances.
     */
    public val customInstanceProfileArn: Output<String>?
        get() = javaResource.customInstanceProfileArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val customJson: Output<String>?
        get() = javaResource.customJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Ids for a set of security groups to apply to the layer's instances.
     */
    public val customSecurityGroupIds: Output<List<String>>?
        get() = javaResource.customSecurityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customSetupRecipes: Output<List<String>>?
        get() = javaResource.customSetupRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customShutdownRecipes: Output<List<String>>?
        get() = javaResource.customShutdownRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val customUndeployRecipes: Output<List<String>>?
        get() = javaResource.customUndeployRecipes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Whether to enable Elastic Load Balancing connection draining.
     */
    public val drainElbOnShutdown: Output<Boolean>?
        get() = javaResource.drainElbOnShutdown().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
     */
    public val ebsVolumes: Output<List<StaticWebLayerEbsVolume>>
        get() = javaResource.ebsVolumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    staticWebLayerEbsVolumeToKotlin(args0)
                })
            })
        })

    /**
     * Name of an Elastic Load Balancer to attach to this layer
     */
    public val elasticLoadBalancer: Output<String>?
        get() = javaResource.elasticLoadBalancer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to install OS and package updates on each instance when it boots.
     */
    public val installUpdatesOnBoot: Output<Boolean>?
        get() = javaResource.installUpdatesOnBoot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
     */
    public val instanceShutdownTimeout: Output<Int>?
        get() = javaResource.instanceShutdownTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val loadBasedAutoScaling: Output<StaticWebLayerLoadBasedAutoScaling>
        get() = javaResource.loadBasedAutoScaling().applyValue({ args0 ->
            args0.let({ args0 ->
                staticWebLayerLoadBasedAutoScalingToKotlin(args0)
            })
        })

    /**
     * A human-readable name for the layer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the stack the layer will belong to.
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * Names of a set of system packages to install on the layer's instances.
     */
    public val systemPackages: Output<List<String>>?
        get() = javaResource.systemPackages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following extra optional arguments, all lists of Chef recipe names, allow
     * custom Chef recipes to be applied to layer instances at the five different
     * lifecycle events, if custom cookbooks are enabled on the layer's stack:
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whether to use EBS-optimized instances.
     */
    public val useEbsOptimizedInstances: Output<Boolean>?
        get() = javaResource.useEbsOptimizedInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StaticWebLayerMapper : ResourceMapper<StaticWebLayer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opsworks.StaticWebLayer::class == javaResource::class

    override fun map(javaResource: Resource): StaticWebLayer = StaticWebLayer(
        javaResource as
            com.pulumi.aws.opsworks.StaticWebLayer,
    )
}

/**
 * @see [StaticWebLayer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticWebLayer].
 */
public suspend fun staticWebLayer(
    name: String,
    block: suspend StaticWebLayerResourceBuilder.() -> Unit,
): StaticWebLayer {
    val builder = StaticWebLayerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticWebLayer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticWebLayer(name: String): StaticWebLayer {
    val builder = StaticWebLayerResourceBuilder()
    builder.name(name)
    return builder.build()
}
