@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin

import com.pulumi.aws.opsworks.UserProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an OpsWorks User Profile resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.UserProfile;
 * import com.pulumi.aws.opsworks.UserProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myProfile = new UserProfile("myProfile", UserProfileArgs.builder()
 *             .userArn(aws_iam_user.user().arn())
 *             .sshUsername("my_user")
 *             .build());
 *     }
 * }
 * ```
 * @property allowSelfManagement Whether users can specify their own SSH public key through the My Settings page
 * @property sshPublicKey The users public key
 * @property sshUsername The ssh username, with witch this user wants to log in
 * @property userArn The user's IAM ARN
 */
public data class UserProfileArgs(
    public val allowSelfManagement: Output<Boolean>? = null,
    public val sshPublicKey: Output<String>? = null,
    public val sshUsername: Output<String>? = null,
    public val userArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.UserProfileArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.UserProfileArgs =
        com.pulumi.aws.opsworks.UserProfileArgs.builder()
            .allowSelfManagement(allowSelfManagement?.applyValue({ args0 -> args0 }))
            .sshPublicKey(sshPublicKey?.applyValue({ args0 -> args0 }))
            .sshUsername(sshUsername?.applyValue({ args0 -> args0 }))
            .userArn(userArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileArgs].
 */
@PulumiTagMarker
public class UserProfileArgsBuilder internal constructor() {
    private var allowSelfManagement: Output<Boolean>? = null

    private var sshPublicKey: Output<String>? = null

    private var sshUsername: Output<String>? = null

    private var userArn: Output<String>? = null

    /**
     * @param value Whether users can specify their own SSH public key through the My Settings page
     */
    @JvmName("crcvweolvsefmdka")
    public suspend fun allowSelfManagement(`value`: Output<Boolean>) {
        this.allowSelfManagement = value
    }

    /**
     * @param value The users public key
     */
    @JvmName("crdaajngpcfhydyc")
    public suspend fun sshPublicKey(`value`: Output<String>) {
        this.sshPublicKey = value
    }

    /**
     * @param value The ssh username, with witch this user wants to log in
     */
    @JvmName("oahrotvvepxmtrgm")
    public suspend fun sshUsername(`value`: Output<String>) {
        this.sshUsername = value
    }

    /**
     * @param value The user's IAM ARN
     */
    @JvmName("xqvrvutgdeesvayl")
    public suspend fun userArn(`value`: Output<String>) {
        this.userArn = value
    }

    /**
     * @param value Whether users can specify their own SSH public key through the My Settings page
     */
    @JvmName("dfnxlypspmwnmbei")
    public suspend fun allowSelfManagement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSelfManagement = mapped
    }

    /**
     * @param value The users public key
     */
    @JvmName("qfbaaghxojrecsfs")
    public suspend fun sshPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKey = mapped
    }

    /**
     * @param value The ssh username, with witch this user wants to log in
     */
    @JvmName("cljglqpfswmbfbyr")
    public suspend fun sshUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshUsername = mapped
    }

    /**
     * @param value The user's IAM ARN
     */
    @JvmName("dtnskwamoxnpinwu")
    public suspend fun userArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userArn = mapped
    }

    internal fun build(): UserProfileArgs = UserProfileArgs(
        allowSelfManagement = allowSelfManagement,
        sshPublicKey = sshPublicKey,
        sshUsername = sshUsername,
        userArn = userArn,
    )
}
