@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.ApplicationAppSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
 * @property revision For sources that are version-aware, the revision to use.
 * @property sshKey SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
 * @property type The type of source to use. For example, "archive".
 * @property url The URL where the app resource can be found.
 * @property username Username to use when authenticating to the source.
 */
public data class ApplicationAppSourceArgs(
    public val password: Output<String>? = null,
    public val revision: Output<String>? = null,
    public val sshKey: Output<String>? = null,
    public val type: Output<String>,
    public val url: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.ApplicationAppSourceArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.ApplicationAppSourceArgs =
        com.pulumi.aws.opsworks.inputs.ApplicationAppSourceArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 }))
            .sshKey(sshKey?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationAppSourceArgs].
 */
@PulumiTagMarker
public class ApplicationAppSourceArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var revision: Output<String>? = null

    private var sshKey: Output<String>? = null

    private var type: Output<String>? = null

    private var url: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("evhpohvoyuqhjkyw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value For sources that are version-aware, the revision to use.
     */
    @JvmName("komfcyrcvclduiri")
    public suspend fun revision(`value`: Output<String>) {
        this.revision = value
    }

    /**
     * @param value SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("sqrrdquhwoclxaey")
    public suspend fun sshKey(`value`: Output<String>) {
        this.sshKey = value
    }

    /**
     * @param value The type of source to use. For example, "archive".
     */
    @JvmName("eowqebckcdkttjsc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The URL where the app resource can be found.
     */
    @JvmName("idkvngevmapiwscx")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Username to use when authenticating to the source.
     */
    @JvmName("vntqhanbdwugytej")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("uaxrprxjfgicvnur")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value For sources that are version-aware, the revision to use.
     */
    @JvmName("yookyttwtayyffjs")
    public suspend fun revision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    /**
     * @param value SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("acbdtbbhgywfaqnd")
    public suspend fun sshKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshKey = mapped
    }

    /**
     * @param value The type of source to use. For example, "archive".
     */
    @JvmName("vcuriiapqcrwippr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The URL where the app resource can be found.
     */
    @JvmName("kkqwgadglktlfllq")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Username to use when authenticating to the source.
     */
    @JvmName("ovywuygysjvjjntp")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ApplicationAppSourceArgs = ApplicationAppSourceArgs(
        password = password,
        revision = revision,
        sshKey = sshKey,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url,
        username = username,
    )
}
