@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.ApplicationEnvironmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Variable name.
 * @property secure Set visibility of the variable value to `true` or `false`.
 * @property value Variable value.
 */
public data class ApplicationEnvironmentArgs(
    public val key: Output<String>,
    public val secure: Output<Boolean>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.ApplicationEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.ApplicationEnvironmentArgs =
        com.pulumi.aws.opsworks.inputs.ApplicationEnvironmentArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .secure(secure?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationEnvironmentArgs].
 */
@PulumiTagMarker
public class ApplicationEnvironmentArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var secure: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Variable name.
     */
    @JvmName("eyavciqcgsmvdnuv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Set visibility of the variable value to `true` or `false`.
     */
    @JvmName("kcpjklwieurwfems")
    public suspend fun secure(`value`: Output<Boolean>) {
        this.secure = value
    }

    /**
     * @param value Variable value.
     */
    @JvmName("osaqslpsinbavnhx")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Variable name.
     */
    @JvmName("ocphwbmgfaokdodw")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Set visibility of the variable value to `true` or `false`.
     */
    @JvmName("xqgtlsjjuhxymade")
    public suspend fun secure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secure = mapped
    }

    /**
     * @param value Variable value.
     */
    @JvmName("hhtjdxdjgkrcgrdw")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ApplicationEnvironmentArgs = ApplicationEnvironmentArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        secure = secure,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
