@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.ApplicationSslConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificate The contents of the certificate's domain.crt file.
 * @property chain Can be used to specify an intermediate certificate authority key or client authentication.
 * @property privateKey The private key; the contents of the certificate's domain.key file.
 */
public data class ApplicationSslConfigurationArgs(
    public val certificate: Output<String>,
    public val chain: Output<String>? = null,
    public val privateKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.ApplicationSslConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.ApplicationSslConfigurationArgs =
        com.pulumi.aws.opsworks.inputs.ApplicationSslConfigurationArgs.builder()
            .certificate(certificate.applyValue({ args0 -> args0 }))
            .chain(chain?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationSslConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationSslConfigurationArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var chain: Output<String>? = null

    private var privateKey: Output<String>? = null

    /**
     * @param value The contents of the certificate's domain.crt file.
     */
    @JvmName("pwcytjyhartbssjo")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Can be used to specify an intermediate certificate authority key or client authentication.
     */
    @JvmName("hjigeujesbqaxvxh")
    public suspend fun chain(`value`: Output<String>) {
        this.chain = value
    }

    /**
     * @param value The private key; the contents of the certificate's domain.key file.
     */
    @JvmName("ahpcqtsnqowogsij")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value The contents of the certificate's domain.crt file.
     */
    @JvmName("unpulonacowtnmwp")
    public suspend fun certificate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Can be used to specify an intermediate certificate authority key or client authentication.
     */
    @JvmName("hstxjuhytnghifke")
    public suspend fun chain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chain = mapped
    }

    /**
     * @param value The private key; the contents of the certificate's domain.key file.
     */
    @JvmName("gkmxkwlynmmrwgng")
    public suspend fun privateKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    internal fun build(): ApplicationSslConfigurationArgs = ApplicationSslConfigurationArgs(
        certificate = certificate ?: throw PulumiNullFieldException("certificate"),
        chain = chain,
        privateKey = privateKey ?: throw PulumiNullFieldException("privateKey"),
    )
}
