@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property downscaling The downscaling settings, as defined below, used for load-based autoscaling
 * @property enable Whether load-based auto scaling is enabled for the layer.
 * @property upscaling The upscaling settings, as defined below, used for load-based autoscaling
 */
public data class CustomLayerLoadBasedAutoScalingArgs(
    public val downscaling: Output<CustomLayerLoadBasedAutoScalingDownscalingArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val upscaling: Output<CustomLayerLoadBasedAutoScalingUpscalingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingArgs =
        com.pulumi.aws.opsworks.inputs.CustomLayerLoadBasedAutoScalingArgs.builder()
            .downscaling(downscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .upscaling(upscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomLayerLoadBasedAutoScalingArgs].
 */
@PulumiTagMarker
public class CustomLayerLoadBasedAutoScalingArgsBuilder internal constructor() {
    private var downscaling: Output<CustomLayerLoadBasedAutoScalingDownscalingArgs>? = null

    private var enable: Output<Boolean>? = null

    private var upscaling: Output<CustomLayerLoadBasedAutoScalingUpscalingArgs>? = null

    /**
     * @param value The downscaling settings, as defined below, used for load-based autoscaling
     */
    @JvmName("pstmfonfbjuvvdbb")
    public suspend fun downscaling(`value`: Output<CustomLayerLoadBasedAutoScalingDownscalingArgs>) {
        this.downscaling = value
    }

    /**
     * @param value Whether load-based auto scaling is enabled for the layer.
     */
    @JvmName("avhuvjpmbkfygwmm")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The upscaling settings, as defined below, used for load-based autoscaling
     */
    @JvmName("anlqevgentlpgvgm")
    public suspend fun upscaling(`value`: Output<CustomLayerLoadBasedAutoScalingUpscalingArgs>) {
        this.upscaling = value
    }

    /**
     * @param value The downscaling settings, as defined below, used for load-based autoscaling
     */
    @JvmName("tbataejvdmtsyknu")
    public suspend fun downscaling(`value`: CustomLayerLoadBasedAutoScalingDownscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downscaling = mapped
    }

    /**
     * @param argument The downscaling settings, as defined below, used for load-based autoscaling
     */
    @JvmName("gipwmaqrrijvmnyr")
    public suspend
    fun downscaling(argument: suspend CustomLayerLoadBasedAutoScalingDownscalingArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLayerLoadBasedAutoScalingDownscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.downscaling = mapped
    }

    /**
     * @param value Whether load-based auto scaling is enabled for the layer.
     */
    @JvmName("rlucmgmoibvlkann")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The upscaling settings, as defined below, used for load-based autoscaling
     */
    @JvmName("dkaxaobkqqyiioce")
    public suspend fun upscaling(`value`: CustomLayerLoadBasedAutoScalingUpscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upscaling = mapped
    }

    /**
     * @param argument The upscaling settings, as defined below, used for load-based autoscaling
     */
    @JvmName("xncyyrpslkmuqpry")
    public suspend
    fun upscaling(argument: suspend CustomLayerLoadBasedAutoScalingUpscalingArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLayerLoadBasedAutoScalingUpscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.upscaling = mapped
    }

    internal fun build(): CustomLayerLoadBasedAutoScalingArgs = CustomLayerLoadBasedAutoScalingArgs(
        downscaling = downscaling,
        enable = enable,
        upscaling = upscaling,
    )
}
