@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.HaproxyLayerLoadBasedAutoScalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property downscaling
 * @property enable
 * @property upscaling
 */
public data class HaproxyLayerLoadBasedAutoScalingArgs(
    public val downscaling: Output<HaproxyLayerLoadBasedAutoScalingDownscalingArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val upscaling: Output<HaproxyLayerLoadBasedAutoScalingUpscalingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.HaproxyLayerLoadBasedAutoScalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.HaproxyLayerLoadBasedAutoScalingArgs =
        com.pulumi.aws.opsworks.inputs.HaproxyLayerLoadBasedAutoScalingArgs.builder()
            .downscaling(downscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .upscaling(upscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HaproxyLayerLoadBasedAutoScalingArgs].
 */
@PulumiTagMarker
public class HaproxyLayerLoadBasedAutoScalingArgsBuilder internal constructor() {
    private var downscaling: Output<HaproxyLayerLoadBasedAutoScalingDownscalingArgs>? = null

    private var enable: Output<Boolean>? = null

    private var upscaling: Output<HaproxyLayerLoadBasedAutoScalingUpscalingArgs>? = null

    /**
     * @param value
     */
    @JvmName("njvbylrhjelcqcmt")
    public suspend fun downscaling(`value`: Output<HaproxyLayerLoadBasedAutoScalingDownscalingArgs>) {
        this.downscaling = value
    }

    /**
     * @param value
     */
    @JvmName("rbbpxunjyhqixlto")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value
     */
    @JvmName("vtpoowofjrnajgnu")
    public suspend fun upscaling(`value`: Output<HaproxyLayerLoadBasedAutoScalingUpscalingArgs>) {
        this.upscaling = value
    }

    /**
     * @param value
     */
    @JvmName("vpkvhnaxgbpkhslx")
    public suspend fun downscaling(`value`: HaproxyLayerLoadBasedAutoScalingDownscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tosirttktyigalyl")
    public suspend
    fun downscaling(argument: suspend HaproxyLayerLoadBasedAutoScalingDownscalingArgsBuilder.() -> Unit) {
        val toBeMapped = HaproxyLayerLoadBasedAutoScalingDownscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.downscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("qttabhfmlavybbjt")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value
     */
    @JvmName("huxirnkqtuwvahkt")
    public suspend fun upscaling(`value`: HaproxyLayerLoadBasedAutoScalingUpscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pwtkxfqtnyvshpkv")
    public suspend
    fun upscaling(argument: suspend HaproxyLayerLoadBasedAutoScalingUpscalingArgsBuilder.() -> Unit) {
        val toBeMapped = HaproxyLayerLoadBasedAutoScalingUpscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.upscaling = mapped
    }

    internal fun build(): HaproxyLayerLoadBasedAutoScalingArgs = HaproxyLayerLoadBasedAutoScalingArgs(
        downscaling = downscaling,
        enable = enable,
        upscaling = upscaling,
    )
}
