@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.InstanceEphemeralBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName
 * @property virtualName
 */
public data class InstanceEphemeralBlockDeviceArgs(
    public val deviceName: Output<String>,
    public val virtualName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.InstanceEphemeralBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.InstanceEphemeralBlockDeviceArgs =
        com.pulumi.aws.opsworks.inputs.InstanceEphemeralBlockDeviceArgs.builder()
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .virtualName(virtualName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceEphemeralBlockDeviceArgs].
 */
@PulumiTagMarker
public class InstanceEphemeralBlockDeviceArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var virtualName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ggtrfopfrfedothg")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value
     */
    @JvmName("wsuyauswcwrvialf")
    public suspend fun virtualName(`value`: Output<String>) {
        this.virtualName = value
    }

    /**
     * @param value
     */
    @JvmName("ywfmsbbwcpsiidcl")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tficjxpfondwpjhp")
    public suspend fun virtualName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualName = mapped
    }

    internal fun build(): InstanceEphemeralBlockDeviceArgs = InstanceEphemeralBlockDeviceArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        virtualName = virtualName ?: throw PulumiNullFieldException("virtualName"),
    )
}
