@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.InstanceRootBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination
 * @property iops
 * @property volumeSize
 * @property volumeType
 */
public data class InstanceRootBlockDeviceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.InstanceRootBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.InstanceRootBlockDeviceArgs =
        com.pulumi.aws.opsworks.inputs.InstanceRootBlockDeviceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceRootBlockDeviceArgs].
 */
@PulumiTagMarker
public class InstanceRootBlockDeviceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qkwkfecbrchfwjap")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value
     */
    @JvmName("cnidxjumrhwpfmuk")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value
     */
    @JvmName("tschnypoofhwtrjg")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value
     */
    @JvmName("dadsdpnmmkgyikmn")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value
     */
    @JvmName("hfnxpqxafrntalrw")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value
     */
    @JvmName("hkpirhglubnqcaep")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value
     */
    @JvmName("yuntiwudxuqggkrc")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("yfaqdjwlpgjavakj")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): InstanceRootBlockDeviceArgs = InstanceRootBlockDeviceArgs(
        deleteOnTermination = deleteOnTermination,
        iops = iops,
        volumeSize = volumeSize,
        volumeType = volumeType,
    )
}
