@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.MysqlLayerEbsVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encrypted
 * @property iops For PIOPS volumes, the IOPS per disk.
 * @property mountPoint The path to mount the EBS volume on the layer's instances.
 * @property numberOfDisks The number of disks to use for the EBS volume.
 * @property raidLevel The RAID level to use for the volume.
 * @property size The size of the volume in gigabytes.
 * @property type The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
 */
public data class MysqlLayerEbsVolumeArgs(
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val mountPoint: Output<String>,
    public val numberOfDisks: Output<Int>,
    public val raidLevel: Output<String>? = null,
    public val size: Output<Int>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.MysqlLayerEbsVolumeArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.MysqlLayerEbsVolumeArgs =
        com.pulumi.aws.opsworks.inputs.MysqlLayerEbsVolumeArgs.builder()
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .mountPoint(mountPoint.applyValue({ args0 -> args0 }))
            .numberOfDisks(numberOfDisks.applyValue({ args0 -> args0 }))
            .raidLevel(raidLevel?.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MysqlLayerEbsVolumeArgs].
 */
@PulumiTagMarker
public class MysqlLayerEbsVolumeArgsBuilder internal constructor() {
    private var encrypted: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var mountPoint: Output<String>? = null

    private var numberOfDisks: Output<Int>? = null

    private var raidLevel: Output<String>? = null

    private var size: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fcoonhsyafqmxrme")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value For PIOPS volumes, the IOPS per disk.
     */
    @JvmName("nbiiqfisvhftlbbo")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value The path to mount the EBS volume on the layer's instances.
     */
    @JvmName("enyffyevpqpdwgqg")
    public suspend fun mountPoint(`value`: Output<String>) {
        this.mountPoint = value
    }

    /**
     * @param value The number of disks to use for the EBS volume.
     */
    @JvmName("vbvibdsyleysgsfu")
    public suspend fun numberOfDisks(`value`: Output<Int>) {
        this.numberOfDisks = value
    }

    /**
     * @param value The RAID level to use for the volume.
     */
    @JvmName("vauprprrvcfhglkb")
    public suspend fun raidLevel(`value`: Output<String>) {
        this.raidLevel = value
    }

    /**
     * @param value The size of the volume in gigabytes.
     */
    @JvmName("abcrxvgljghjgwho")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
     */
    @JvmName("byjchyklkicrbrdq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("tqcbdajagoybwlna")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value For PIOPS volumes, the IOPS per disk.
     */
    @JvmName("xwxnvkbsfyyolbbs")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value The path to mount the EBS volume on the layer's instances.
     */
    @JvmName("agsrnmcltwdyxgvs")
    public suspend fun mountPoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPoint = mapped
    }

    /**
     * @param value The number of disks to use for the EBS volume.
     */
    @JvmName("fidcbkijktgdexwu")
    public suspend fun numberOfDisks(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfDisks = mapped
    }

    /**
     * @param value The RAID level to use for the volume.
     */
    @JvmName("hswdfrmqkymngagf")
    public suspend fun raidLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raidLevel = mapped
    }

    /**
     * @param value The size of the volume in gigabytes.
     */
    @JvmName("eijeighoahstpovt")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
     */
    @JvmName("tnsgkbsfsfrfveej")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MysqlLayerEbsVolumeArgs = MysqlLayerEbsVolumeArgs(
        encrypted = encrypted,
        iops = iops,
        mountPoint = mountPoint ?: throw PulumiNullFieldException("mountPoint"),
        numberOfDisks = numberOfDisks ?: throw PulumiNullFieldException("numberOfDisks"),
        raidLevel = raidLevel,
        size = size ?: throw PulumiNullFieldException("size"),
        type = type,
    )
}
