@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.MysqlLayerLoadBasedAutoScalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property downscaling
 * @property enable
 * @property upscaling
 */
public data class MysqlLayerLoadBasedAutoScalingArgs(
    public val downscaling: Output<MysqlLayerLoadBasedAutoScalingDownscalingArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val upscaling: Output<MysqlLayerLoadBasedAutoScalingUpscalingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.MysqlLayerLoadBasedAutoScalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.MysqlLayerLoadBasedAutoScalingArgs =
        com.pulumi.aws.opsworks.inputs.MysqlLayerLoadBasedAutoScalingArgs.builder()
            .downscaling(downscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .upscaling(upscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MysqlLayerLoadBasedAutoScalingArgs].
 */
@PulumiTagMarker
public class MysqlLayerLoadBasedAutoScalingArgsBuilder internal constructor() {
    private var downscaling: Output<MysqlLayerLoadBasedAutoScalingDownscalingArgs>? = null

    private var enable: Output<Boolean>? = null

    private var upscaling: Output<MysqlLayerLoadBasedAutoScalingUpscalingArgs>? = null

    /**
     * @param value
     */
    @JvmName("vmogabapgaxmnnur")
    public suspend fun downscaling(`value`: Output<MysqlLayerLoadBasedAutoScalingDownscalingArgs>) {
        this.downscaling = value
    }

    /**
     * @param value
     */
    @JvmName("pwxitgutkpavyqcc")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value
     */
    @JvmName("badocsmlocvjpfmt")
    public suspend fun upscaling(`value`: Output<MysqlLayerLoadBasedAutoScalingUpscalingArgs>) {
        this.upscaling = value
    }

    /**
     * @param value
     */
    @JvmName("bpeyoeciacmdmkbs")
    public suspend fun downscaling(`value`: MysqlLayerLoadBasedAutoScalingDownscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rlwxltwrainceaox")
    public suspend
    fun downscaling(argument: suspend MysqlLayerLoadBasedAutoScalingDownscalingArgsBuilder.() -> Unit) {
        val toBeMapped = MysqlLayerLoadBasedAutoScalingDownscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.downscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("fefcgmaappptxypg")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value
     */
    @JvmName("ccgecucndicuunpx")
    public suspend fun upscaling(`value`: MysqlLayerLoadBasedAutoScalingUpscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bfclgseppjxoilyn")
    public suspend
    fun upscaling(argument: suspend MysqlLayerLoadBasedAutoScalingUpscalingArgsBuilder.() -> Unit) {
        val toBeMapped = MysqlLayerLoadBasedAutoScalingUpscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.upscaling = mapped
    }

    internal fun build(): MysqlLayerLoadBasedAutoScalingArgs = MysqlLayerLoadBasedAutoScalingArgs(
        downscaling = downscaling,
        enable = enable,
        upscaling = upscaling,
    )
}
