@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.NodejsAppLayerCloudwatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property logStreams
 */
public data class NodejsAppLayerCloudwatchConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val logStreams: Output<List<NodejsAppLayerCloudwatchConfigurationLogStreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.NodejsAppLayerCloudwatchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.NodejsAppLayerCloudwatchConfigurationArgs =
        com.pulumi.aws.opsworks.inputs.NodejsAppLayerCloudwatchConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logStreams(
                logStreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NodejsAppLayerCloudwatchConfigurationArgs].
 */
@PulumiTagMarker
public class NodejsAppLayerCloudwatchConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logStreams: Output<List<NodejsAppLayerCloudwatchConfigurationLogStreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("vuaxyrailjhegmdj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("lgslavbertbxjtim")
    public suspend
    fun logStreams(`value`: Output<List<NodejsAppLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = value
    }

    @JvmName("ycfsbyxymsqdutwv")
    public suspend fun logStreams(
        vararg
        values: Output<NodejsAppLayerCloudwatchConfigurationLogStreamArgs>,
    ) {
        this.logStreams = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kmunqqoqlrglbggw")
    public suspend
    fun logStreams(values: List<Output<NodejsAppLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dvbsjcptmwgrcqrp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("ipfdiqjstxnrgoji")
    public suspend
    fun logStreams(`value`: List<NodejsAppLayerCloudwatchConfigurationLogStreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("crgklcobwgiwphxi")
    public suspend
    fun logStreams(argument: List<suspend NodejsAppLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NodejsAppLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ufyfltxqxbmmdcsb")
    public suspend fun logStreams(
        vararg
        argument: suspend NodejsAppLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NodejsAppLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("awmvuvxomgbbcjlx")
    public suspend
    fun logStreams(argument: suspend NodejsAppLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NodejsAppLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param values
     */
    @JvmName("itmprxhogfjpmodr")
    public suspend fun logStreams(vararg values: NodejsAppLayerCloudwatchConfigurationLogStreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    internal fun build(): NodejsAppLayerCloudwatchConfigurationArgs =
        NodejsAppLayerCloudwatchConfigurationArgs(
            enabled = enabled,
            logStreams = logStreams,
        )
}
