@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingUpscalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarms
 * @property cpuThreshold
 * @property ignoreMetricsTime
 * @property instanceCount
 * @property loadThreshold
 * @property memoryThreshold
 * @property thresholdsWaitTime
 */
public data class NodejsAppLayerLoadBasedAutoScalingUpscalingArgs(
    public val alarms: Output<List<String>>? = null,
    public val cpuThreshold: Output<Double>? = null,
    public val ignoreMetricsTime: Output<Int>? = null,
    public val instanceCount: Output<Int>? = null,
    public val loadThreshold: Output<Double>? = null,
    public val memoryThreshold: Output<Double>? = null,
    public val thresholdsWaitTime: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingUpscalingArgs> {
    override fun toJava():
        com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingUpscalingArgs =
        com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingUpscalingArgs.builder()
            .alarms(alarms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpuThreshold(cpuThreshold?.applyValue({ args0 -> args0 }))
            .ignoreMetricsTime(ignoreMetricsTime?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .loadThreshold(loadThreshold?.applyValue({ args0 -> args0 }))
            .memoryThreshold(memoryThreshold?.applyValue({ args0 -> args0 }))
            .thresholdsWaitTime(thresholdsWaitTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodejsAppLayerLoadBasedAutoScalingUpscalingArgs].
 */
@PulumiTagMarker
public class NodejsAppLayerLoadBasedAutoScalingUpscalingArgsBuilder internal constructor() {
    private var alarms: Output<List<String>>? = null

    private var cpuThreshold: Output<Double>? = null

    private var ignoreMetricsTime: Output<Int>? = null

    private var instanceCount: Output<Int>? = null

    private var loadThreshold: Output<Double>? = null

    private var memoryThreshold: Output<Double>? = null

    private var thresholdsWaitTime: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("vnkbsjfpguxnwhmf")
    public suspend fun alarms(`value`: Output<List<String>>) {
        this.alarms = value
    }

    @JvmName("dumkocpvtrnlpwjc")
    public suspend fun alarms(vararg values: Output<String>) {
        this.alarms = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rsgmesjvifpsyumm")
    public suspend fun alarms(values: List<Output<String>>) {
        this.alarms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dngfvyjioesibukg")
    public suspend fun cpuThreshold(`value`: Output<Double>) {
        this.cpuThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("gfqusvspxdbcosgt")
    public suspend fun ignoreMetricsTime(`value`: Output<Int>) {
        this.ignoreMetricsTime = value
    }

    /**
     * @param value
     */
    @JvmName("cwmosbjsteestoxj")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value
     */
    @JvmName("ylxlgxbywrbsjbfr")
    public suspend fun loadThreshold(`value`: Output<Double>) {
        this.loadThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("sxgntxhyodjqdkax")
    public suspend fun memoryThreshold(`value`: Output<Double>) {
        this.memoryThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("igyhuqypeckeynrl")
    public suspend fun thresholdsWaitTime(`value`: Output<Int>) {
        this.thresholdsWaitTime = value
    }

    /**
     * @param value
     */
    @JvmName("lwxevlsnmgftqvmu")
    public suspend fun alarms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param values
     */
    @JvmName("wxkaatjkqcowqavu")
    public suspend fun alarms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param value
     */
    @JvmName("mbovlijbwgccwduc")
    public suspend fun cpuThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("lcqdomqnbffapwmv")
    public suspend fun ignoreMetricsTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMetricsTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("mmecaedebxotxtvk")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("vuqxjngrufknpcta")
    public suspend fun loadThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("tdqxyrglnuvgfyji")
    public suspend fun memoryThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("jixnkyvjiobxcdnm")
    public suspend fun thresholdsWaitTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdsWaitTime = mapped
    }

    internal fun build(): NodejsAppLayerLoadBasedAutoScalingUpscalingArgs =
        NodejsAppLayerLoadBasedAutoScalingUpscalingArgs(
            alarms = alarms,
            cpuThreshold = cpuThreshold,
            ignoreMetricsTime = ignoreMetricsTime,
            instanceCount = instanceCount,
            loadThreshold = loadThreshold,
            memoryThreshold = memoryThreshold,
            thresholdsWaitTime = thresholdsWaitTime,
        )
}
