@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property logStreams
 */
public data class PhpAppLayerCloudwatchConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val logStreams: Output<List<PhpAppLayerCloudwatchConfigurationLogStreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationArgs =
        com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logStreams(
                logStreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PhpAppLayerCloudwatchConfigurationArgs].
 */
@PulumiTagMarker
public class PhpAppLayerCloudwatchConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logStreams: Output<List<PhpAppLayerCloudwatchConfigurationLogStreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("qwhlxhtboufiaaiy")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("yboeucmboxbtkpex")
    public suspend
    fun logStreams(`value`: Output<List<PhpAppLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = value
    }

    @JvmName("csgxfsdlycduxfnk")
    public suspend fun logStreams(
        vararg
        values: Output<PhpAppLayerCloudwatchConfigurationLogStreamArgs>,
    ) {
        this.logStreams = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dqlhbqhlwbecootn")
    public suspend
    fun logStreams(values: List<Output<PhpAppLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("sxxwrmuvybibijuh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("cferfsgrstnpuinl")
    public suspend fun logStreams(`value`: List<PhpAppLayerCloudwatchConfigurationLogStreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ptclkvngndgobtis")
    public suspend
    fun logStreams(argument: List<suspend PhpAppLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PhpAppLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bnjebmsgtmujxxpf")
    public suspend fun logStreams(
        vararg
        argument: suspend PhpAppLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PhpAppLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qsxsgbchcnyixjeg")
    public suspend
    fun logStreams(argument: suspend PhpAppLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PhpAppLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param values
     */
    @JvmName("jjdebmjrfnjpkoeg")
    public suspend fun logStreams(vararg values: PhpAppLayerCloudwatchConfigurationLogStreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    internal fun build(): PhpAppLayerCloudwatchConfigurationArgs =
        PhpAppLayerCloudwatchConfigurationArgs(
            enabled = enabled,
            logStreams = logStreams,
        )
}
