@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.StaticWebLayerLoadBasedAutoScalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property downscaling
 * @property enable
 * @property upscaling
 */
public data class StaticWebLayerLoadBasedAutoScalingArgs(
    public val downscaling: Output<StaticWebLayerLoadBasedAutoScalingDownscalingArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val upscaling: Output<StaticWebLayerLoadBasedAutoScalingUpscalingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.StaticWebLayerLoadBasedAutoScalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.StaticWebLayerLoadBasedAutoScalingArgs =
        com.pulumi.aws.opsworks.inputs.StaticWebLayerLoadBasedAutoScalingArgs.builder()
            .downscaling(downscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .upscaling(upscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StaticWebLayerLoadBasedAutoScalingArgs].
 */
@PulumiTagMarker
public class StaticWebLayerLoadBasedAutoScalingArgsBuilder internal constructor() {
    private var downscaling: Output<StaticWebLayerLoadBasedAutoScalingDownscalingArgs>? = null

    private var enable: Output<Boolean>? = null

    private var upscaling: Output<StaticWebLayerLoadBasedAutoScalingUpscalingArgs>? = null

    /**
     * @param value
     */
    @JvmName("nqbdodcnyidmxyio")
    public suspend
    fun downscaling(`value`: Output<StaticWebLayerLoadBasedAutoScalingDownscalingArgs>) {
        this.downscaling = value
    }

    /**
     * @param value
     */
    @JvmName("ixdriaimnytihnvn")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value
     */
    @JvmName("fjgonahaodesmbmd")
    public suspend fun upscaling(`value`: Output<StaticWebLayerLoadBasedAutoScalingUpscalingArgs>) {
        this.upscaling = value
    }

    /**
     * @param value
     */
    @JvmName("dlldqyonkokqdjnm")
    public suspend fun downscaling(`value`: StaticWebLayerLoadBasedAutoScalingDownscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uagmdajikdbmoela")
    public suspend
    fun downscaling(argument: suspend StaticWebLayerLoadBasedAutoScalingDownscalingArgsBuilder.() -> Unit) {
        val toBeMapped = StaticWebLayerLoadBasedAutoScalingDownscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.downscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("atpoxlfgsukqsmgw")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value
     */
    @JvmName("btmbbdcfegcldupx")
    public suspend fun upscaling(`value`: StaticWebLayerLoadBasedAutoScalingUpscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("isogphskqbrbflnf")
    public suspend
    fun upscaling(argument: suspend StaticWebLayerLoadBasedAutoScalingUpscalingArgsBuilder.() -> Unit) {
        val toBeMapped = StaticWebLayerLoadBasedAutoScalingUpscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.upscaling = mapped
    }

    internal fun build(): StaticWebLayerLoadBasedAutoScalingArgs =
        StaticWebLayerLoadBasedAutoScalingArgs(
            downscaling = downscaling,
            enable = enable,
            upscaling = upscaling,
        )
}
