@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificate The contents of the certificate's domain.crt file.
 * @property chain Can be used to specify an intermediate certificate authority key or client authentication.
 * @property privateKey The private key; the contents of the certificate's domain.key file.
 */
public data class ApplicationSslConfiguration(
    public val certificate: String,
    public val chain: String? = null,
    public val privateKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.ApplicationSslConfiguration):
            ApplicationSslConfiguration = ApplicationSslConfiguration(
            certificate = javaType.certificate(),
            chain = javaType.chain().map({ args0 -> args0 }).orElse(null),
            privateKey = javaType.privateKey(),
        )
    }
}
