@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabled
 * @property logStreams A block the specifies how an opsworks logs look like. See Log Streams.
 */
public data class CustomLayerCloudwatchConfiguration(
    public val enabled: Boolean? = null,
    public val logStreams: List<CustomLayerCloudwatchConfigurationLogStream>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.CustomLayerCloudwatchConfiguration):
            CustomLayerCloudwatchConfiguration = CustomLayerCloudwatchConfiguration(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            logStreams = javaType.logStreams().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opsworks.kotlin.outputs.CustomLayerCloudwatchConfigurationLogStream.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
