@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property downscaling The downscaling settings, as defined below, used for load-based autoscaling
 * @property enable Whether load-based auto scaling is enabled for the layer.
 * @property upscaling The upscaling settings, as defined below, used for load-based autoscaling
 */
public data class CustomLayerLoadBasedAutoScaling(
    public val downscaling: CustomLayerLoadBasedAutoScalingDownscaling? = null,
    public val enable: Boolean? = null,
    public val upscaling: CustomLayerLoadBasedAutoScalingUpscaling? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.CustomLayerLoadBasedAutoScaling):
            CustomLayerLoadBasedAutoScaling = CustomLayerLoadBasedAutoScaling(
            downscaling = javaType.downscaling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opsworks.kotlin.outputs.CustomLayerLoadBasedAutoScalingDownscaling.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            upscaling = javaType.upscaling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.opsworks.kotlin.outputs.CustomLayerLoadBasedAutoScalingUpscaling.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
