@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination
 * @property deviceName
 * @property iops
 * @property snapshotId
 * @property volumeSize
 * @property volumeType
 */
public data class InstanceEbsBlockDevice(
    public val deleteOnTermination: Boolean? = null,
    public val deviceName: String,
    public val iops: Int? = null,
    public val snapshotId: String? = null,
    public val volumeSize: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.InstanceEbsBlockDevice):
            InstanceEbsBlockDevice = InstanceEbsBlockDevice(
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            deviceName = javaType.deviceName(),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
