@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encrypted
 * @property iops For PIOPS volumes, the IOPS per disk.
 * @property mountPoint The path to mount the EBS volume on the layer's instances.
 * @property numberOfDisks The number of disks to use for the EBS volume.
 * @property raidLevel The RAID level to use for the volume.
 * @property size The size of the volume in gigabytes.
 * @property type The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
 */
public data class MysqlLayerEbsVolume(
    public val encrypted: Boolean? = null,
    public val iops: Int? = null,
    public val mountPoint: String,
    public val numberOfDisks: Int,
    public val raidLevel: String? = null,
    public val size: Int,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.MysqlLayerEbsVolume):
            MysqlLayerEbsVolume = MysqlLayerEbsVolume(
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            mountPoint = javaType.mountPoint(),
            numberOfDisks = javaType.numberOfDisks(),
            raidLevel = javaType.raidLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
