@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password Password to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
 * @property revision For sources that are version-aware, the revision to use.
 * @property sshKey SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
 * @property type The type of source to use. For example, "archive".
 * @property url The URL where the cookbooks resource can be found.
 * @property username Username to use when authenticating to the source.
 */
public data class StackCustomCookbooksSource(
    public val password: String? = null,
    public val revision: String? = null,
    public val sshKey: String? = null,
    public val type: String,
    public val url: String,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.StackCustomCookbooksSource):
            StackCustomCookbooksSource = StackCustomCookbooksSource(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            sshKey = javaType.sshKey().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
