@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.kotlin.outputs.OrganizationAccount
import com.pulumi.aws.organizations.kotlin.outputs.OrganizationNonMasterAccount
import com.pulumi.aws.organizations.kotlin.outputs.OrganizationRoot
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.organizations.kotlin.outputs.OrganizationAccount.Companion.toKotlin as organizationAccountToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.OrganizationNonMasterAccount.Companion.toKotlin as organizationNonMasterAccountToKotlin
import com.pulumi.aws.organizations.kotlin.outputs.OrganizationRoot.Companion.toKotlin as organizationRootToKotlin

/**
 * Builder for [Organization].
 */
@PulumiTagMarker
public class OrganizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationArgs = OrganizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationArgsBuilder.() -> Unit) {
        val builder = OrganizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Organization {
        val builtJavaResource = com.pulumi.aws.organizations.Organization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Organization(builtJavaResource)
    }
}

/**
 * Provides a resource to create an organization.
 * !> **WARNING:** When migrating from a `feature_set` of `CONSOLIDATED_BILLING` to `ALL`, the Organization account owner will received an email stating the following: "You started the process to enable all features for your AWS organization. As part of that process, all member accounts that joined your organization by invitation must approve the change. You don’t need approval from member accounts that you directly created from within your AWS organization." After all member accounts have accepted the invitation, the Organization account owner must then finalize the changes via the [AWS Console](https://console&#46;aws&#46;amazon&#46;com/organizations/home#/organization/settings/migration-progress)&#46; Until these steps are performed, the provider will perpetually show a difference, and the `DescribeOrganization` API will continue to show the `FeatureSet` as `CONSOLIDATED_BILLING`&#46; See the [AWS Organizations documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) for more information.
 * !> **WARNING:** [Warning from the AWS Docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html): "We recommend that you enable integration between AWS Organizations and the specified AWS service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization's accounts depends on that service. For more information, see the documentation for the other AWS service."
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var org = new Organization("org", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals(
 *                 "cloudtrail.amazonaws.com",
 *                 "config.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the AWS organization using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:organizations/organization:Organization my_org o-1234567
 * ```
 *
 */
public class Organization internal constructor(
    override val javaResource: com.pulumi.aws.organizations.Organization,
) : KotlinCustomResource(javaResource, OrganizationMapper) {
    /**
     * List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
     */
    public val accounts: Output<List<OrganizationAccount>>
        get() = javaResource.accounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    organizationAccountToKotlin(args0)
                })
            })
        })

    /**
     * ARN of the root
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
     */
    public val awsServiceAccessPrincipals: Output<List<String>>?
        get() = javaResource.awsServiceAccessPrincipals().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
     */
    public val enabledPolicyTypes: Output<List<String>>?
        get() = javaResource.enabledPolicyTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specify "ALL" (default) or "CONSOLIDATED_BILLING".
     */
    public val featureSet: Output<String>?
        get() = javaResource.featureSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the master account
     */
    public val masterAccountArn: Output<String>
        get() = javaResource.masterAccountArn().applyValue({ args0 -> args0 })

    /**
     * Email address of the master account
     */
    public val masterAccountEmail: Output<String>
        get() = javaResource.masterAccountEmail().applyValue({ args0 -> args0 })

    /**
     * Identifier of the master account
     */
    public val masterAccountId: Output<String>
        get() = javaResource.masterAccountId().applyValue({ args0 -> args0 })

    /**
     * List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
     */
    public val nonMasterAccounts: Output<List<OrganizationNonMasterAccount>>
        get() = javaResource.nonMasterAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> organizationNonMasterAccountToKotlin(args0) })
            })
        })

    /**
     * List of organization roots. All elements have these attributes:
     */
    public val roots: Output<List<OrganizationRoot>>
        get() = javaResource.roots().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    organizationRootToKotlin(args0)
                })
            })
        })
}

public object OrganizationMapper : ResourceMapper<Organization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.organizations.Organization::class == javaResource::class

    override fun map(javaResource: Resource): Organization = Organization(
        javaResource as
            com.pulumi.aws.organizations.Organization,
    )
}

/**
 * @see [Organization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Organization].
 */
public suspend fun organization(
    name: String,
    block: suspend OrganizationResourceBuilder.() -> Unit,
): Organization {
    val builder = OrganizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Organization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organization(name: String): Organization {
    val builder = OrganizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
