@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.OrganizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an organization.
 * !> **WARNING:** When migrating from a `feature_set` of `CONSOLIDATED_BILLING` to `ALL`, the Organization account owner will received an email stating the following: "You started the process to enable all features for your AWS organization. As part of that process, all member accounts that joined your organization by invitation must approve the change. You don’t need approval from member accounts that you directly created from within your AWS organization." After all member accounts have accepted the invitation, the Organization account owner must then finalize the changes via the [AWS Console](https://console&#46;aws&#46;amazon&#46;com/organizations/home#/organization/settings/migration-progress)&#46; Until these steps are performed, the provider will perpetually show a difference, and the `DescribeOrganization` API will continue to show the `FeatureSet` as `CONSOLIDATED_BILLING`&#46; See the [AWS Organizations documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) for more information.
 * !> **WARNING:** [Warning from the AWS Docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html): "We recommend that you enable integration between AWS Organizations and the specified AWS service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization's accounts depends on that service. For more information, see the documentation for the other AWS service."
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var org = new Organization("org", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals(
 *                 "cloudtrail.amazonaws.com",
 *                 "config.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the AWS organization using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:organizations/organization:Organization my_org o-1234567
 * ```
 * @property awsServiceAccessPrincipals List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
 * @property enabledPolicyTypes List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
 * @property featureSet Specify "ALL" (default) or "CONSOLIDATED_BILLING".
 */
public data class OrganizationArgs(
    public val awsServiceAccessPrincipals: Output<List<String>>? = null,
    public val enabledPolicyTypes: Output<List<String>>? = null,
    public val featureSet: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.OrganizationArgs> {
    override fun toJava(): com.pulumi.aws.organizations.OrganizationArgs =
        com.pulumi.aws.organizations.OrganizationArgs.builder()
            .awsServiceAccessPrincipals(
                awsServiceAccessPrincipals?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .enabledPolicyTypes(enabledPolicyTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .featureSet(featureSet?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationArgs].
 */
@PulumiTagMarker
public class OrganizationArgsBuilder internal constructor() {
    private var awsServiceAccessPrincipals: Output<List<String>>? = null

    private var enabledPolicyTypes: Output<List<String>>? = null

    private var featureSet: Output<String>? = null

    /**
     * @param value List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
     */
    @JvmName("njhllnormlafdiup")
    public suspend fun awsServiceAccessPrincipals(`value`: Output<List<String>>) {
        this.awsServiceAccessPrincipals = value
    }

    @JvmName("xyjksamyhumksvek")
    public suspend fun awsServiceAccessPrincipals(vararg values: Output<String>) {
        this.awsServiceAccessPrincipals = Output.all(values.asList())
    }

    /**
     * @param values List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
     */
    @JvmName("qcilyvuhtmytlsfw")
    public suspend fun awsServiceAccessPrincipals(values: List<Output<String>>) {
        this.awsServiceAccessPrincipals = Output.all(values)
    }

    /**
     * @param value List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
     */
    @JvmName("vqgbwweeiwtrsqgi")
    public suspend fun enabledPolicyTypes(`value`: Output<List<String>>) {
        this.enabledPolicyTypes = value
    }

    @JvmName("vpunwvawsjfirktr")
    public suspend fun enabledPolicyTypes(vararg values: Output<String>) {
        this.enabledPolicyTypes = Output.all(values.asList())
    }

    /**
     * @param values List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
     */
    @JvmName("afwumnjlxlwkdumo")
    public suspend fun enabledPolicyTypes(values: List<Output<String>>) {
        this.enabledPolicyTypes = Output.all(values)
    }

    /**
     * @param value Specify "ALL" (default) or "CONSOLIDATED_BILLING".
     */
    @JvmName("wrljilgdfshrbhuj")
    public suspend fun featureSet(`value`: Output<String>) {
        this.featureSet = value
    }

    /**
     * @param value List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
     */
    @JvmName("jvseigeqaqgxbgnw")
    public suspend fun awsServiceAccessPrincipals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsServiceAccessPrincipals = mapped
    }

    /**
     * @param values List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
     */
    @JvmName("chseglertsqyhdmv")
    public suspend fun awsServiceAccessPrincipals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsServiceAccessPrincipals = mapped
    }

    /**
     * @param value List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
     */
    @JvmName("bjjckklqrnobjlyb")
    public suspend fun enabledPolicyTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledPolicyTypes = mapped
    }

    /**
     * @param values List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
     */
    @JvmName("kurubdgmctodokeb")
    public suspend fun enabledPolicyTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledPolicyTypes = mapped
    }

    /**
     * @param value Specify "ALL" (default) or "CONSOLIDATED_BILLING".
     */
    @JvmName("moxnslbrqkyyjurm")
    public suspend fun featureSet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureSet = mapped
    }

    internal fun build(): OrganizationArgs = OrganizationArgs(
        awsServiceAccessPrincipals = awsServiceAccessPrincipals,
        enabledPolicyTypes = enabledPolicyTypes,
        featureSet = featureSet,
    )
}
