@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.kotlin.outputs.OrganizationalUnitAccount
import com.pulumi.aws.organizations.kotlin.outputs.OrganizationalUnitAccount.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [OrganizationalUnit].
 */
@PulumiTagMarker
public class OrganizationalUnitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationalUnitArgs = OrganizationalUnitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationalUnitArgsBuilder.() -> Unit) {
        val builder = OrganizationalUnitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OrganizationalUnit {
        val builtJavaResource = com.pulumi.aws.organizations.OrganizationalUnit(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrganizationalUnit(builtJavaResource)
    }
}

/**
 * Provides a resource to create an organizational unit.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.OrganizationalUnit;
 * import com.pulumi.aws.organizations.OrganizationalUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationalUnit("example", OrganizationalUnitArgs.builder()
 *             .parentId(aws_organizations_organization.example().roots()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Organizations Organizational Units using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:organizations/organizationalUnit:OrganizationalUnit example ou-1234567
 * ```
 *
 */
public class OrganizationalUnit internal constructor(
    override val javaResource: com.pulumi.aws.organizations.OrganizationalUnit,
) : KotlinCustomResource(javaResource, OrganizationalUnitMapper) {
    /**
     * List of child accounts for this Organizational Unit. Does not return account information for child Organizational Units. All elements have these attributes:
     */
    public val accounts: Output<List<OrganizationalUnitAccount>>
        get() = javaResource.accounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * ARN of the organizational unit
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name for the organizational unit
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the parent organizational unit, which may be the root
     */
    public val parentId: Output<String>
        get() = javaResource.parentId().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object OrganizationalUnitMapper : ResourceMapper<OrganizationalUnit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.organizations.OrganizationalUnit::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationalUnit = OrganizationalUnit(
        javaResource as
            com.pulumi.aws.organizations.OrganizationalUnit,
    )
}

/**
 * @see [OrganizationalUnit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationalUnit].
 */
public suspend fun organizationalUnit(
    name: String,
    block: suspend OrganizationalUnitResourceBuilder.() -> Unit,
): OrganizationalUnit {
    val builder = OrganizationalUnitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationalUnit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationalUnit(name: String): OrganizationalUnit {
    val builder = OrganizationalUnitResourceBuilder()
    builder.name(name)
    return builder.build()
}
